/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.List;
import oracle.eclipse.tools.webservices.model.bindings.IBinding;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IInvalid;
import oracle.eclipse.tools.webservices.model.bindings.IService;
import oracle.eclipse.tools.webservices.model.bindings.IServicePort;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import oracle.eclipse.tools.webservices.model.jws.JWSModel;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.JWSService;
import oracle.eclipse.tools.webservices.model.jws.internal.AbstractJWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.BindingsPropertyDef2;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlBinding;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlPort;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlService;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValuePropertyBinding;

public class JWSServiceResource
extends AbstractJWSModelElement {
    private final JWSModel parent;
    private BindingsPropertyDef2<JWSServiceResource, IWsdlService, IService, Value<String>> classname;
    private BindingsPropertyDef2<JWSServiceResource, IWsdlService, IService, Value<String>> javadoc;
    private BindingsPropertyDef2<JWSServiceResource, IWsdlPort, IServicePort, Value<String>> portName;
    private BindingsPropertyDef2<JWSServiceResource, IWsdlBinding, IBinding, Value<String>> bindingName;
    private BindingsPropertyDef2<JWSServiceResource, IWsdlService, IService, Value<String>> serviceName;
    private BindingsPropertyDef2<JWSServiceResource, IWsdlBinding, IBinding, Value<Boolean>> mimeContentEnabled;
    private IWsdlService service;
    private IWsdlPort port;
    final JWSModelElement<JWSServiceResource, IWsdlBinding, IBinding> bindingElement = new JWSModelElement<JWSServiceResource, IWsdlBinding, IBinding>(null, IBinding.PROP_BINDING_NAME, NodeNameBinding.Patterns.binding){

        @Override
        public void setWsdlModelElement(IWsdlBinding wsdl) {
            super.setWsdlModelElement(wsdl);
            if (wsdl == null) {
                JWSServiceResource.this.service = null;
                JWSServiceResource.this.port = null;
                return;
            }
            String bindingName = wsdl.getName().text();
            IWsdlModel wsdlModel = (IWsdlModel)wsdl.nearest(IWsdlModel.class);
            for (IWsdlService service : wsdlModel.getServices()) {
                for (IWsdlPort port : service.getPorts()) {
                    if (!bindingName.equals(port.getBindingName().text())) continue;
                    JWSServiceResource.this.service = service;
                    JWSServiceResource.this.port = port;
                    return;
                }
            }
        }

        @Override
        public JWSService getModelElement() {
            return (JWSService)JWSServiceResource.this.element();
        }

        @Override
        public IBinding createNewBindings() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSServiceResource.this.parent.nearest(JWSModelGroup.class);
            if (jwsModelGroup == null) {
                return null;
            }
            IBinding binding = (IBinding)((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getBindings().insert();
            IWsdlBinding wsdlBinding = (IWsdlBinding)this.getWsdlModelElement();
            if (wsdlBinding != null) {
                binding.setBindingName(wsdlBinding.getName().text());
            }
            return binding;
        }

        @Override
        protected List<IBinding> getBindingsElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSServiceResource.this.parent.nearest(JWSModelGroup.class);
            return ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getBindings();
        }

        @Override
        protected List<IInvalid> getInvalidElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSServiceResource.this.parent.nearest(JWSModelGroup.class);
            return ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getInvalids();
        }
    };
    final JWSModelElement<JWSServiceResource, IWsdlService, IService> serviceElement = new JWSModelElement<JWSServiceResource, IWsdlService, IService>(null, IService.PROP_SERVICE_NAME, NodeNameBinding.Patterns.service){

        @Override
        public IWsdlService getWsdlModelElement() {
            return JWSServiceResource.this.service;
        }

        @Override
        public JWSService getModelElement() {
            return (JWSService)JWSServiceResource.this.element();
        }

        @Override
        public IService createNewBindings() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSServiceResource.this.parent.nearest(JWSModelGroup.class);
            if (jwsModelGroup == null) {
                return null;
            }
            IService service = (IService)((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getServices().insert();
            IWsdlService wsdlService = this.getWsdlModelElement();
            if (wsdlService != null) {
                service.setServiceName(wsdlService.getName().text());
            }
            return service;
        }

        @Override
        protected List<IService> getBindingsElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSServiceResource.this.parent.nearest(JWSModelGroup.class);
            return ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getServices();
        }

        @Override
        protected List<IInvalid> getInvalidElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSServiceResource.this.parent.nearest(JWSModelGroup.class);
            return ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getInvalids();
        }
    };
    final JWSModelElement<JWSServiceResource, IWsdlPort, IServicePort> portElement = new JWSModelElement<JWSServiceResource, IWsdlPort, IServicePort>(null, IServicePort.PROP_PORT_NAME, NodeNameBinding.Patterns.port){

        @Override
        public IWsdlPort getWsdlModelElement() {
            return JWSServiceResource.this.port;
        }

        @Override
        public IServicePort createNewBindings() {
            IWsdlPort wsdlPort;
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSServiceResource.this.parent.nearest(JWSModelGroup.class);
            if (jwsModelGroup == null) {
                return null;
            }
            IServicePort port = (IServicePort)((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getServicePorts().insert();
            IWsdlService wsdlService = JWSServiceResource.this.serviceElement.getWsdlModelElement();
            if (wsdlService != null) {
                port.setServiceName(wsdlService.getName().text());
            }
            if ((wsdlPort = this.getWsdlModelElement()) != null) {
                port.setPortName(wsdlPort.getName().text());
            }
            return port;
        }

        @Override
        public JWSService getModelElement() {
            return (JWSService)JWSServiceResource.this.element();
        }

        @Override
        protected List<IServicePort> getBindingsElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSServiceResource.this.parent.nearest(JWSModelGroup.class);
            return ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getServicePorts();
        }

        @Override
        protected List<IInvalid> getInvalidElements() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSServiceResource.this.parent.nearest(JWSModelGroup.class);
            return ((IBindingsSet)jwsModelGroup.getBindingsSet().content()).getInvalids();
        }
    };

    public JWSServiceResource(JWSModel model, Resource resource) {
        super(resource);
        this.parent = model;
        this.classname = new BindingsPropertyDef2(this.serviceElement, IService.PROP_CLASS_NAME, null, JWSService.PROP_CLASS_NAME);
        this.javadoc = new BindingsPropertyDef2(this.serviceElement, IService.PROP_JAVADOC, null, JWSService.PROP_JAVA_DOC, this.classname);
        this.portName = new BindingsPropertyDef2(this.portElement, IServicePort.PROP_PORT_NAME, IWsdlPort.PROP_NAME, JWSService.PROP_PORT_NAME);
        this.bindingName = new BindingsPropertyDef2(this.bindingElement, IBinding.PROP_BINDING_NAME, IWsdlBinding.PROP_NAME, JWSService.PROP_BINDING_NAME);
        this.mimeContentEnabled = new BindingsPropertyDef2(this.bindingElement, IBinding.PROP_ENABLE_MIME_CONTENT, null, JWSService.PROP_MIME_CONTENT_ENABLED);
        this.serviceName = new BindingsPropertyDef2(this.serviceElement, IService.PROP_SERVICE_NAME, IWsdlService.PROP_NAME, JWSService.PROP_SERVICE_NAME);
        this.addModelElement(this.bindingElement);
        this.addModelElement(this.serviceElement);
        this.addModelElement(this.portElement);
    }

    public JWSModel getModel() {
        return this.parent;
    }

    public void init(Element element) {
        super.init(element);
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == JWSService.PROP_BINDING_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSServiceResource.this.getBindingName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == JWSService.PROP_CLASS_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSServiceResource.this.getClassName();
                }

                public void write(String value) {
                    JWSServiceResource.this.setClassName(value);
                }
            };
        }
        if (p == JWSService.PROP_JAVA_DOC) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSServiceResource.this.getJavaDoc();
                }

                public void write(String value) {
                    JWSServiceResource.this.setJavaDoc(value);
                }
            };
        }
        if (p == JWSService.PROP_MIME_CONTENT_ENABLED) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSServiceResource.this.isMimeContentEnabled();
                }

                public void write(String value) {
                    JWSServiceResource.this.setMimeContentEnabled(value);
                }
            };
        }
        if (p == JWSService.PROP_PORT_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSServiceResource.this.getPortName();
                }

                public void write(String value) {
                    JWSServiceResource.this.setPortNameOnBinding(value);
                }
            };
        }
        if (p == JWSService.PROP_SERVICE_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSServiceResource.this.getServiceName();
                }

                public void write(String value) {
                }
            };
        }
        return null;
    }

    public String getClassName() {
        return this.classname.get();
    }

    public String getJavaDoc() {
        return this.javadoc.get();
    }

    public String getBindingName() {
        return this.bindingName.get();
    }

    public String getPortName() {
        return this.portName.get();
    }

    public void setPortNameOnBinding(String name) {
        this.portElement.setKeyBindingValue(name);
        for (JWSService service : this.parent.getServices()) {
            if (!service.getPortName().text().equals(name)) continue;
            this.bindingElement.setKeyBindingValue(service.getBindingName().text());
            this.serviceElement.setKeyBindingValue(service.getServiceName().text());
            break;
        }
        this.parent.getServices().refresh();
    }

    public String getServiceName() {
        return this.serviceName.get();
    }

    public String isMimeContentEnabled() {
        return this.mimeContentEnabled.get();
    }

    public void setClassName(String name) {
        this.classname.set(name);
    }

    public void setJavaDoc(String doc) {
        this.javadoc.set(doc);
    }

    public void setMimeContentEnabled(Boolean enabled) {
        this.mimeContentEnabled.set(enabled);
    }

    public void setMimeContentEnabled(String enabled) {
        this.mimeContentEnabled.set(enabled);
    }

    public void removePortBinding() {
        this.portElement.removeBinding();
        this.serviceElement.removeBinding();
        this.bindingElement.removeBinding();
        this.parent.getServices().refresh();
    }
}

