/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IInvalid;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperation;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperationFault;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import oracle.eclipse.tools.webservices.model.jws.JWSModel;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.JWSOperation;
import oracle.eclipse.tools.webservices.model.jws.internal.BindingsModelListController2;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelResource;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSOperationResource;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperation;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationFault;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlPortType;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;

final class JWSOperationsListController
extends ListPropertyBinding {
    private final JWSModel p;
    private Map<String, JWSOperationResource> current = new LinkedHashMap<String, JWSOperationResource>();
    private final BindingsModelListController2<IWsdlPortType, IBindingsSet, JWSOperationResource, IWsdlOperationFault, IPortTypeOperationFault> faultController = new BindingsModelListController2<IWsdlPortType, IBindingsSet, JWSOperationResource, IWsdlOperationFault, IPortTypeOperationFault>(IPortTypeOperationFault.PROP_OPERATION_NAME, null, IBindingsSet.PROP_FAULTS, null, NodeNameBinding.Patterns.portTypeOperation){

        IWsdlPortType[] getWsdlListParents() {
            return new IWsdlPortType[0];
        }

        IBindingsSet[] getBindingListParents() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSOperationsListController.this.p.nearest(JWSModelGroup.class);
            return new IBindingsSet[]{(IBindingsSet)jwsModelGroup.getBindingsSet().content()};
        }

        @Override
        JWSOperationResource create() {
            return new JWSOperationResource(JWSOperationsListController.this.p, JWSOperationsListController.this.p.resource());
        }

        @Override
        JWSModelElement<JWSOperationResource, IWsdlOperationFault, IPortTypeOperationFault> adaptToJWSModelElement(JWSOperationResource model) {
            return model.faultElement;
        }

        @Override
        protected boolean filterBindingsElement(IPortTypeOperationFault operation) {
            return ObjectUtil.equal((Object)JWSOperationsListController.this.p.getServiceName().text(), (Object)operation.getPortTypeName().text());
        }

        @Override
        protected boolean filterInvalidElement(IInvalid invalid) {
            XmlResource xmlResource = (XmlResource)invalid.resource();
            XmlElement element = xmlResource.getXmlElement();
            if (ObjectUtil.equal((Object)JWSOperationsListController.this.p.getServiceName().text(), (Object)NodeNameBinding.Patterns.portType.getValue(element))) {
                return super.filterInvalidElement(invalid);
            }
            return false;
        }
    };
    private final BindingsModelListController2<IWsdlPortType, IBindingsSet, JWSOperationResource, IWsdlOperation, IPortTypeOperation> portTypeController = new BindingsModelListController2<IWsdlPortType, IBindingsSet, JWSOperationResource, IWsdlOperation, IPortTypeOperation>(IPortTypeOperation.PROP_OPERATION_NAME, IWsdlOperation.PROP_OPERATION_NAME, IBindingsSet.PROP_OPERATIONS, IWsdlPortType.PROP_PORT_TYPE_OPERATIONS){

        @Override
        JWSModelElement<JWSOperationResource, IWsdlOperation, IPortTypeOperation> adaptToJWSModelElement(JWSOperationResource model) {
            return model.operationElement;
        }

        @Override
        JWSOperationResource create() {
            return new JWSOperationResource(JWSOperationsListController.this.p, JWSOperationsListController.this.p.resource());
        }

        IBindingsSet[] getBindingListParents() {
            JWSModelGroup jwsModelGroup = (JWSModelGroup)JWSOperationsListController.this.p.nearest(JWSModelGroup.class);
            return new IBindingsSet[]{(IBindingsSet)jwsModelGroup.getBindingsSet().content()};
        }

        IWsdlPortType[] getWsdlListParents() {
            return new IWsdlPortType[]{((JWSModelResource)((JWSOperationsListController)JWSOperationsListController.this).p.resource()).portTypeElement.getWsdlModelElement()};
        }

        @Override
        protected boolean filterBindingsElement(IPortTypeOperation operation) {
            return ObjectUtil.equal((Object)JWSOperationsListController.this.p.getServiceName().text(), (Object)operation.getPortTypeName().text());
        }
    };

    JWSOperationsListController(JWSModel parent) {
        this.p = parent;
    }

    public ElementType type(Resource resource) {
        return JWSOperation.TYPE;
    }

    public List<Resource> read() {
        if (this.current.isEmpty()) {
            LinkedHashMap updates = new LinkedHashMap();
            this.portTypeController.refresh(this.current, updates);
            this.faultController.refresh(this.current, updates);
            this.current.clear();
            for (String key : updates.keySet()) {
                this.current.put(key, (JWSOperationResource)((Object)updates.get(key)));
            }
        }
        return new ArrayList<Resource>(this.current.values());
    }
}

