/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import oracle.eclipse.tools.webservices.model.bindings.IOperationParameter;
import oracle.eclipse.tools.webservices.model.jws.JWSOperation;
import oracle.eclipse.tools.webservices.model.jws.JWSOperationParameter;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSDefaultValueService;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSOperationParameterResource;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaElement;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlMessagePart;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.DefaultValueServiceData;

public class JWSOperationParameterNameService
extends JWSDefaultValueService {
    private final ValueProperty defaultProperty = JWSOperation.PROP_WRAPPER_STYLE;
    private Element parent;
    private Listener listener;

    protected void initDefaultValueService() {
        ValueProperty property = (ValueProperty)this.context(ValueProperty.class);
        Element element = (Element)this.context(Element.class);
        if (property != null && element != null) {
            this.parent = element;
            while (this.parent != null && this.defaultProperty.getModelElementType() != this.parent.type()) {
                Property p = this.parent.parent();
                Element element2 = this.parent = p == null ? null : p.element();
            }
        }
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                JWSOperationParameterNameService.this.refresh();
            }
        };
        JWSOperationParameter model = (JWSOperationParameter)this.context(JWSOperationParameter.class);
        model.attach(this.listener, "../WrapperStyle");
    }

    public void dispose() {
        if (this.listener != null) {
            JWSOperationParameter model = (JWSOperationParameter)this.context(JWSOperationParameter.class);
            model.detach(this.listener, "../WrapperStyle");
            this.listener = null;
        }
        super.dispose();
    }

    protected DefaultValueServiceData compute() {
        Element modelElement = (Element)this.context(Element.class);
        if (modelElement != null) {
            return new DefaultValueServiceData(this.getDefault(modelElement));
        }
        return new DefaultValueServiceData("");
    }

    public String getDefault(Element element) {
        assert (element instanceof IOperationParameter);
        JWSOperationParameterResource operationParam = (JWSOperationParameterResource)element.resource();
        JWSOperation jwsOperation = (JWSOperation)element.nearest(JWSOperation.class);
        if (jwsOperation != null && ((Boolean)jwsOperation.isWrapperStyle().content()).booleanValue()) {
            ISchemaElement schema = operationParam.getSchemaElement();
            if (schema == null) {
                return null;
            }
            String name = schema.getRefName().text();
            if (name == null || name.length() == 0) {
                name = schema.getElementName().text();
            }
            if (name == null || name.length() == 0) {
                return name;
            }
            StringBuilder paramName = new StringBuilder(name.substring(0, 1).toLowerCase());
            if (name.length() > 1) {
                paramName.append(name.substring(1));
            }
            return paramName.toString();
        }
        IWsdlMessagePart part = operationParam.partElement.getWsdlModelElement();
        return part == null ? null : part.getPartName().text();
    }
}

