/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IInvalid;
import oracle.eclipse.tools.webservices.model.bindings.IPortType;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperation;
import oracle.eclipse.tools.webservices.model.bindings.IPortTypeOperationFault;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import oracle.eclipse.tools.webservices.model.jws.JWSHandler;
import oracle.eclipse.tools.webservices.model.jws.JWSJavaPackage;
import oracle.eclipse.tools.webservices.model.jws.JWSModel;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.JWSOperation;
import oracle.eclipse.tools.webservices.model.jws.JWSService;
import oracle.eclipse.tools.webservices.model.jws.internal.AbstractJWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.BindingsPropertyDef2;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSOperationResource;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSOperationsListController;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSServiceListController;
import oracle.eclipse.tools.webservices.model.jws.internal.JavaPackageResource;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperation;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlOperationFault;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlPortType;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ElementPropertyBinding;

public final class JWSModelResource
extends AbstractJWSModelElement {
    private final JWSModelGroup group;
    private JavaPackageResource javaPackage;
    private BindingsPropertyDef2<JWSModelResource, IWsdlPortType, IPortType, Value<String>> className;
    private BindingsPropertyDef2<JWSModelResource, IWsdlPortType, IPortType, Value<String>> javaDoc;
    private BindingsPropertyDef2<JWSModelResource, IWsdlPortType, IPortType, Value<Boolean>> wrapperStyle;
    private BindingsPropertyDef2<JWSModelResource, IWsdlPortType, IPortType, Value<Boolean>> async;
    final JWSModelElement<JWSModelResource, IWsdlPortType, IPortType> portTypeElement = new JWSModelElement<JWSModelResource, IWsdlPortType, IPortType>(IWsdlPortType.PROP_PORT_TYPE_NAME, IPortType.PROP_PORT_TYPE_NAME, NodeNameBinding.Patterns.portType){

        @Override
        public IPortType createNewBindings() {
            IPortType portType = (IPortType)((IBindingsSet)JWSModelResource.this.group.getBindingsSet().content()).getPortTypes().insert();
            IWsdlPortType wsdlPortType = (IWsdlPortType)this.getWsdlModelElement();
            if (wsdlPortType != null) {
                portType.setPortTypeName(wsdlPortType.getPortTypeName().text());
            }
            return portType;
        }

        @Override
        protected List<IPortType> getBindingsElements() {
            return ((IBindingsSet)JWSModelResource.this.group.getBindingsSet().content()).getPortTypes();
        }

        @Override
        public JWSModel getModelElement() {
            return (JWSModel)JWSModelResource.this.element();
        }

        @Override
        protected List<IInvalid> getInvalidElements() {
            if (JWSModelResource.this.group.getBindingsSet() != null && JWSModelResource.this.group.getBindingsSet().element() != null) {
                return ((IBindingsSet)JWSModelResource.this.group.getBindingsSet().content()).getInvalids();
            }
            return Collections.emptyList();
        }
    };
    final JWSModelElement<JWSModelResource, IWsdlOperation, IPortTypeOperation> operationElement = new JWSModelElement<JWSModelResource, IWsdlOperation, IPortTypeOperation>(null, IPortTypeOperation.PROP_PORT_TYPE_NAME, NodeNameBinding.Patterns.portType){

        @Override
        public IPortTypeOperation createNewBindings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JWSModel getModelElement() {
            return (JWSModel)JWSModelResource.this.element();
        }

        @Override
        protected List<IPortTypeOperation> getBindingsElements() {
            return ((IBindingsSet)JWSModelResource.this.group.getBindingsSet().content()).getOperations();
        }

        @Override
        protected List<IInvalid> getInvalidElements() {
            if (JWSModelResource.this.group.getBindingsSet() != null && JWSModelResource.this.group.getBindingsSet().element() != null) {
                return ((IBindingsSet)JWSModelResource.this.group.getBindingsSet().content()).getInvalids();
            }
            return Collections.emptyList();
        }
    };
    final JWSModelElement<JWSModelResource, IWsdlOperationFault, IPortTypeOperationFault> faultElement = new JWSModelElement<JWSModelResource, IWsdlOperationFault, IPortTypeOperationFault>(null, IPortTypeOperationFault.PROP_PORT_TYPE_NAME, NodeNameBinding.Patterns.portType){

        @Override
        protected JWSModel getModelElement() {
            return (JWSModel)JWSModelResource.this.element();
        }

        @Override
        protected IPortTypeOperationFault createNewBindings() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected List<IPortTypeOperationFault> getBindingsElements() {
            return null;
        }

        @Override
        protected List<IInvalid> getInvalidElements() {
            return null;
        }
    };

    static {
        JWSModelResource.addKeyProperty(JWSModel.PROP_SERVICE_NAME, JWSModelGroup.PROP_JAVA_WEBSERVICES, JWSModelGroup.PROP_SERVICE_ENDPOINT_INTERFACES, JWSModelGroup.PROP_SERVICE_IMPLEMENTATIONS);
        JWSModelResource.addKeyProperty(JWSOperation.PROP_OPERATION_NAME, JWSModel.PROP_OPERATIONS);
        JWSModelResource.addKeyProperty(JWSService.PROP_BINDING_NAME, JWSModel.PROP_SERVICES);
        JWSModelResource.addKeyProperty(JWSService.PROP_SERVICE_NAME, JWSModel.PROP_SERVICES);
        JWSModelResource.addKeyProperty(JWSService.PROP_PORT_NAME, JWSModel.PROP_SERVICES);
    }

    public JWSModelResource(Element parent, Resource resource) {
        super(resource);
        this.group = (JWSModelGroup)parent;
    }

    public void init(Element element) {
        super.init(element);
        this.javaPackage = new JavaPackageResource(this.group, this);
        this.className = new BindingsPropertyDef2(this.portTypeElement, IPortType.PROP_CLASS_NAME, null, JWSModel.PROP_CLASS_NAME);
        this.javaDoc = new BindingsPropertyDef2(this.portTypeElement, IPortType.PROP_JAVADOC, null, JWSModel.PROP_JAVA_DOC, this.className);
        this.wrapperStyle = new BindingsPropertyDef2(this.portTypeElement, IPortType.PROP_ENABLE_WRAPPER_STYLE, null, JWSModel.PROP_WRAPPER_STYLE_ENABLED);
        this.async = new BindingsPropertyDef2(this.portTypeElement, IPortType.PROP_ENABLE_ASYNC_MAPPING, null, JWSModel.PROP_ASYNC_ENABLED);
        this.addModelElement(this.portTypeElement, JWSModel.PROP_SERVICE_NAME);
        this.addModelElement(this.operationElement, JWSModel.PROP_SERVICE_NAME);
        this.addModelElement(this.faultElement, JWSModel.PROP_SERVICE_NAME);
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == JWSModel.PROP_JAVA_PACKAGE) {
            return new ElementPropertyBinding(){

                public ElementType type(Resource resource) {
                    return JWSJavaPackage.TYPE;
                }

                public Resource read() {
                    return JWSModelResource.this.javaPackage;
                }
            };
        }
        if (p == JWSModel.PROP_CLASS_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSModelResource.this.getClassName();
                }

                public void write(String value) {
                    JWSModelResource.this.setClassName(value);
                }
            };
        }
        if (p == JWSModel.PROP_JAVA_DOC) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSModelResource.this.getJavaDoc();
                }

                public void write(String value) {
                    JWSModelResource.this.setJavaDoc(value);
                }
            };
        }
        if (p == JWSModel.PROP_WRAPPER_STYLE_ENABLED) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSModelResource.this.isWrapperStyleEnabled();
                }

                public void write(String value) {
                    JWSModelResource.this.setWrapperStyleEnabled(value);
                }
            };
        }
        if (p == JWSModel.PROP_ASYNC_ENABLED) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSModelResource.this.isAsyncEnabled();
                }

                public void write(String value) {
                    JWSModelResource.this.setAsyncEnabled(value);
                }
            };
        }
        if (p == JWSModel.PROP_HANDLERS) {
            ListPropertyBinding controller = new ListPropertyBinding(){

                public List<Resource> read() {
                    return Collections.emptyList();
                }

                public ElementType type(Resource resource) {
                    return JWSHandler.TYPE;
                }
            };
            return controller;
        }
        if (p == JWSModel.PROP_OPERATIONS) {
            return new JWSOperationsListController((JWSModel)this.element());
        }
        if (p == JWSModel.PROP_SERVICE_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSModelResource.this.getServiceName();
                }

                public void write(String value) {
                    JWSModelResource.this.setServiceNameOnBinding(value);
                }
            };
        }
        if (p == JWSModel.PROP_SERVICES) {
            return new JWSServiceListController((JWSModel)this.element(), this);
        }
        if (p == JWSModel.PROP_WSDL_URI) {
            return new ValuePropertyBinding(){

                public String read() {
                    return JWSModelResource.this.getWsdlURI();
                }

                public void write(String value) {
                }
            };
        }
        return null;
    }

    public String getClassName() {
        return this.className.get();
    }

    public ElementList<JWSHandler> getHandlers() {
        return new ElementList(this.element(), JWSModel.PROP_HANDLERS);
    }

    public String getJavaDoc() {
        return this.javaDoc.get();
    }

    public JavaPackageResource getPackage() {
        return this.javaPackage;
    }

    public String getServiceName() {
        return this.getKeyValue();
    }

    public void setServiceNameOnBinding(String name) {
        this.portTypeElement.setKeyBindingValue(name);
        for (JWSOperation operation : ((JWSModel)this.element()).getOperations()) {
            ((JWSOperationResource)operation.resource()).setServiceName(name);
        }
        this.parent().element().property(JWSModelGroup.PROP_JAVA_WEBSERVICES).refresh();
        this.element().property(JWSModel.PROP_OPERATIONS).refresh();
    }

    public String getWsdlURI() {
        return this.group.getWsdlURI().text(false);
    }

    public String isWrapperStyleEnabled() {
        return this.wrapperStyle.get();
    }

    public String isAsyncEnabled() {
        return this.async.get();
    }

    public void setClassName(String cname) {
        this.className.set(cname);
    }

    public void setJavaDoc(String jdoc) {
        this.javaDoc.set(jdoc);
    }

    public void setWrapperStyleEnabled(Boolean enable) {
        this.wrapperStyle.set(enable);
    }

    public void setWrapperStyleEnabled(String enable) {
        this.wrapperStyle.set(enable);
    }

    public void setAsyncEnabled(Boolean enable) {
        this.async.set(enable);
    }

    public void setAsyncEnabled(String enable) {
        this.async.set(enable);
    }
}

