/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IDefinitions;
import oracle.eclipse.tools.webservices.model.bindings.IInvalid;
import oracle.eclipse.tools.webservices.model.jws.JWSJavaPackage;
import oracle.eclipse.tools.webservices.model.jws.JWSModel;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.internal.BindingsPropertyDef2;
import oracle.eclipse.tools.webservices.model.jws.internal.HandlerChainListController;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import oracle.eclipse.tools.webservices.model.jws.internal.JavaPackageResource;
import oracle.eclipse.tools.webservices.model.jws.internal.WebServicesListController;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ElementPropertyBinding;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public final class JWSModelGroupResource
extends RootXmlResource {
    private static final String[] EMPTY_PARAMS = new String[0];
    private JWSModelElement<JWSModelGroupResource, IWsdlModel, IDefinitions> definitionsJwsElement;
    private JWSModelElement<JWSModelGroupResource, IWsdlModel, IBindingsSet> bindingsSetJwsElement;
    private BindingsPropertyDef2<JWSModelGroupResource, IWsdlModel, IDefinitions, Value<Boolean>> wrapperStyle;
    private BindingsPropertyDef2<JWSModelGroupResource, IWsdlModel, IDefinitions, Value<Boolean>> async;
    private BindingsPropertyDef2<JWSModelGroupResource, IWsdlModel, IDefinitions, Value<Boolean>> mimeContent;
    private BindingsPropertyDef2<JWSModelGroupResource, IWsdlModel, IBindingsSet, Value<String>> wsdlURI;
    private JavaPackageResource javaPackage;

    public JWSModelGroupResource(XmlResourceStore store) {
        super(store);
    }

    public void init(Element modelElement) {
        super.init(modelElement);
        this.definitionsJwsElement = new JWSModelElement<JWSModelGroupResource, IWsdlModel, IDefinitions>(null, null, null){

            @Override
            public List<IDefinitions> getBindingsElements() {
                return Collections.unmodifiableList(JWSModelGroupResource.this.getBindingsSet().getDefinitions());
            }

            @Override
            public IDefinitions createNewBindings() {
                return (IDefinitions)JWSModelGroupResource.this.getBindingsSet().getDefinitions().insert();
            }

            @Override
            public JWSModelGroup getModelElement() {
                return (JWSModelGroup)JWSModelGroupResource.this.element();
            }

            @Override
            protected IWsdlModel getWsdlModelElement() {
                return (IWsdlModel)this.getModelElement().getWsdlModel().content(true);
            }

            @Override
            protected List<IInvalid> getInvalidElements() {
                return JWSModelGroupResource.this.getBindingsSet().getInvalids();
            }
        };
        this.bindingsSetJwsElement = new JWSModelElement<JWSModelGroupResource, IWsdlModel, IBindingsSet>(null, null, null){

            @Override
            public List<IBindingsSet> getBindingsElements() {
                return Collections.singletonList((IBindingsSet)((JWSModelGroup)JWSModelGroupResource.this.element()).getBindingsSet().content());
            }

            @Override
            public JWSModelGroup getModelElement() {
                return (JWSModelGroup)JWSModelGroupResource.this.element();
            }

            @Override
            public IWsdlModel getWsdlModelElement() {
                return (IWsdlModel)this.getModelElement().getWsdlModel().content(true);
            }

            @Override
            protected IBindingsSet createNewBindings() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected List<IInvalid> getInvalidElements() {
                return ((IBindingsSet)((JWSModelGroup)JWSModelGroupResource.this.element()).getBindingsSet().content()).getInvalids();
            }
        };
        this.wrapperStyle = new BindingsPropertyDef2(this.definitionsJwsElement, IDefinitions.PROP_ENABLE_WRAPPER_STYLE, null, JWSModelGroup.PROP_WRAPPER_STYLE_ENABLED);
        this.async = new BindingsPropertyDef2(this.definitionsJwsElement, IDefinitions.PROP_ENABLE_ASYNC_MAPPING, null, JWSModelGroup.PROP_ASYNC_ENABLED);
        this.mimeContent = new BindingsPropertyDef2(this.definitionsJwsElement, IDefinitions.PROP_ENABLE_MIME_CONTENT, null, JWSModelGroup.PROP_MIME_CONTENT_ENABLED);
        this.wsdlURI = new BindingsPropertyDef2(this.bindingsSetJwsElement, IBindingsSet.PROP_WSDL_URI, null, JWSModelGroup.PROP_WSDL_URI);
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        Object binding = null;
        if (p == JWSModelGroup.PROP_ASYNC_ENABLED) {
            binding = new ValuePropertyBinding(){

                public String read() {
                    return JWSModelGroupResource.this.isAsyncEnabled();
                }

                public void write(String value) {
                    JWSModelGroupResource.this.setAsyncEnabled(value);
                }
            };
        } else if (p == JWSModelGroup.PROP_JAVA_PACKAGE) {
            binding = new ElementPropertyBinding(){
                private JavaPackageResource javaPackage;

                public ElementType type(Resource resource) {
                    return JWSJavaPackage.TYPE;
                }

                public Resource read() {
                    return this.javaPackage;
                }

                public Resource create(ElementType type) {
                    this.javaPackage = new JavaPackageResource((JWSModelGroup)JWSModelGroupResource.this.element(), (Resource)JWSModelGroupResource.this);
                    return this.javaPackage;
                }
            };
        } else if (p == JWSModelGroup.PROP_MIME_CONTENT_ENABLED) {
            binding = new ValuePropertyBinding(){

                public String read() {
                    return JWSModelGroupResource.this.isMimeContentEnabled();
                }

                public void write(String value) {
                    JWSModelGroupResource.this.setMimeContentEnabled(value);
                }
            };
        } else if (p == JWSModelGroup.PROP_WRAPPER_STYLE_ENABLED) {
            binding = new ValuePropertyBinding(){

                public String read() {
                    return JWSModelGroupResource.this.isWrapperStyleEnabled();
                }

                public void write(String value) {
                    JWSModelGroupResource.this.setWrapperStyleEnabled(value);
                }
            };
        } else if (p == JWSModelGroup.PROP_WSDL_URI) {
            binding = new ValuePropertyBinding(){

                public String read() {
                    return JWSModelGroupResource.this.getWsdlURI();
                }

                public void write(String value) {
                    JWSModelGroupResource.this.setWsdlURI(value);
                }
            };
        } else if (p == JWSModelGroup.PROP_BINDINGS_SET) {
            binding = new ElementPropertyBinding(){
                Resource resource;
                {
                    this.resource = new RootXmlResource(JWSModelGroupResource.this.store());
                }

                public Resource read() {
                    return this.resource;
                }

                public ElementType type(Resource resource) {
                    return IBindingsSet.TYPE;
                }
            };
        } else if (p == JWSModelGroup.PROP_HANDLER_CHAINS) {
            binding = new HandlerChainListController((JWSModelGroup)this.element());
        } else if (p == JWSModelGroup.PROP_JAVA_WEBSERVICES) {
            binding = new WebServicesListController(property);
        } else if (p == JWSModelGroup.PROP_SERVICE_ENDPOINT_INTERFACES) {
            binding = new WebServicesListController(property);
        } else if (p == JWSModelGroup.PROP_WSDL_MODEL) {
            binding = new ElementPropertyBinding(){
                private RootXmlResource element;

                public ElementType type(Resource resource) {
                    return IWsdlModel.TYPE;
                }

                public Resource read() {
                    return this.element;
                }

                public Resource create(ElementType type) {
                    IFile f = null;
                    String uriString = JWSModelGroupResource.this.getWsdlURI();
                    if (uriString == null) {
                        return null;
                    }
                    URI uri = null;
                    try {
                        uri = new URI(uriString);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    if (uri == null || uri.getScheme() == null) {
                        IFile bindingsFile = (IFile)JWSModelGroupResource.this.adapt(IFile.class);
                        f = EclipseFileUtil.computeReferencedFile((IFile)bindingsFile, (String)uriString);
                    }
                    if (f != null) {
                        try {
                            XmlResourceStore xmlResourceStore = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(f));
                            this.element = new RootXmlResource(xmlResourceStore);
                        }
                        catch (ResourceStoreException e) {
                            e.printStackTrace();
                        }
                    }
                    return this.element;
                }
            };
        }
        if (binding != null) {
            return binding;
        }
        return super.createBinding(property);
    }

    public JavaPackageResource getPackage() {
        return this.javaPackage;
    }

    public ElementList<JWSModel> getServiceImplementations() {
        return new ElementList(this.element(), JWSModelGroup.PROP_SERVICE_IMPLEMENTATIONS);
    }

    public String getWsdlURI() {
        return this.wsdlURI.get();
    }

    public IBindingsSet getBindingsSet() {
        if (!this.element().disposed()) {
            return (IBindingsSet)((JWSModelGroup)this.element()).getBindingsSet().content();
        }
        return null;
    }

    public IWsdlModel getWsdlModel() {
        return (IWsdlModel)((JWSModelGroup)this.element()).getWsdlModel().content(true);
    }

    public String isAsyncEnabled() {
        return this.async.get();
    }

    public String isMimeContentEnabled() {
        return this.mimeContent.get();
    }

    public String isWrapperStyleEnabled() {
        return this.wrapperStyle.get();
    }

    public void setAsyncEnabled(Boolean enable) {
        this.async.set(enable);
    }

    public void setMimeContentEnabled(Boolean enable) {
        this.mimeContent.set(enable);
    }

    public void setWrapperStyleEnabled(Boolean enable) {
        this.wrapperStyle.set(enable);
    }

    public void setWsdlURI(String uri) {
        this.wsdlURI.set(uri);
    }

    public void setAsyncEnabled(String enable) {
        this.async.set(enable);
    }

    public void setMimeContentEnabled(String enable) {
        this.mimeContent.set(enable);
    }

    public void setWrapperStyleEnabled(String enable) {
        this.wrapperStyle.set(enable);
    }
}

