/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.List;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsElement;
import oracle.eclipse.tools.webservices.model.bindings.IInvalid;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.xml.XmlResource;

abstract class JWSModelElement<JWS_MODEL_TYPE extends Resource, WSDL_MODEL_TYPE extends Element, BINDINGS_MODEL_TYPE extends IBindingsElement> {
    private WSDL_MODEL_TYPE wsdlModel;
    final ValueProperty wsdlKeyProperty;
    final ValueProperty bindingsKeyProperty;
    final NodeNameBinding.Patterns pattern;

    protected JWSModelElement(ValueProperty wsdlKey, ValueProperty bindingsKey, NodeNameBinding.Patterns keyPattern) {
        this.wsdlKeyProperty = wsdlKey;
        this.bindingsKeyProperty = bindingsKey;
        this.pattern = keyPattern;
    }

    protected abstract List<BINDINGS_MODEL_TYPE> getBindingsElements();

    protected void clearBindingsElements() {
        this.getBindingsElements().clear();
    }

    protected abstract BINDINGS_MODEL_TYPE createNewBindings();

    protected WSDL_MODEL_TYPE getWsdlModelElement() {
        return this.wsdlModel;
    }

    protected void setWsdlModelElement(WSDL_MODEL_TYPE wsdl) {
        this.wsdlModel = wsdl;
    }

    protected abstract Element getModelElement();

    protected abstract List<IInvalid> getInvalidElements();

    protected String getKeyValue() {
        WSDL_MODEL_TYPE wsdlModelType;
        if (this.wsdlKeyProperty != null && (wsdlModelType = this.getWsdlModelElement()) != null) {
            return JWSModelElement.getString(this.wsdlKeyProperty, wsdlModelType);
        }
        String value = null;
        if (this.bindingsKeyProperty != null) {
            for (IBindingsElement bindingsModelType : this.getBindingsElements()) {
                value = JWSModelElement.getString(this.bindingsKeyProperty, bindingsModelType);
                if (value == null) continue;
                return value;
            }
        }
        if (this.pattern != null) {
            for (IInvalid invalid : this.getInvalidElements()) {
                XmlResource resource = (XmlResource)invalid.resource();
                value = this.pattern.getValue(resource.getXmlElement());
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    protected void setKeyBindingValue(String value) {
        this.setBindingValue(this.bindingsKeyProperty, value);
    }

    protected void setBindingValue(ValueProperty p, String value) {
        if (p != null) {
            for (IBindingsElement bindingsModelType : this.getBindingsElements()) {
                JWSModelElement.setString(p, bindingsModelType, value);
            }
        }
    }

    protected Status validateWsdlElement() {
        if (this.getWsdlModelElement() == null) {
            String node = null;
            if (this.getBindingsElements().size() > 0) {
                node = ((IBindingsElement)this.getBindingsElements().get(0)).getNode().text();
            }
            if (node == null && this.getInvalidElements().size() > 0) {
                node = this.getInvalidElements().get(0).getNode().text();
            }
            if (node != null) {
                return this.createErrorStatus(Messages.bind((String)Messages.jws_model_no_target_node, (Object)node, (Object)"1002"));
            }
            return this.createErrorStatus(Messages.bind((String)Messages.jws_model_unknown_target_node, (Object)"1002"));
        }
        return Status.createOkStatus();
    }

    protected Status validateInvalids() {
        if (this.getInvalidElements() != null && this.getInvalidElements().size() > 0) {
            IInvalid invalid = this.getInvalidElements().get(0);
            return this.createErrorStatus(Messages.bind((String)Messages.jws_model_invalid_node_attribute, (Object)invalid.getNode().text(), (Object)"1001"));
        }
        return Status.createOkStatus();
    }

    protected Status createErrorStatus(String message) {
        return Status.createErrorStatus((String)message);
    }

    public static void setString(ValueProperty p, Element m, String s) {
        if (m != null) {
            assert (p.getModelElementType() == m.type());
            m.property(p).write((Object)s);
        }
    }

    public static String getString(ValueProperty p, Element m) {
        if (m == null) {
            return null;
        }
        assert (p.getModelElementType() == m.type());
        Value v = m.property(p);
        return v == null ? null : v.text(false);
    }

    public void removeBinding() {
        this.clearBindingsElements();
    }
}

