/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.List;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsElement;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelElement;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;

final class BindingsPropertyDef2<JWS_MODEL_TYPE extends Resource, WSDL_MODEL_TYPE extends Element, BINDINGS_MODEL_TYPE extends IBindingsElement, VALUE_TYPE extends Value<?>> {
    private final JWSModelElement<JWS_MODEL_TYPE, WSDL_MODEL_TYPE, BINDINGS_MODEL_TYPE> jwsElement;
    private final ValueProperty wsdlPropertyDef;
    private final ValueProperty bindingsPropertyDef;
    private final ValueProperty jwsPropertyDef;
    private BindingsPropertyDef2 child;
    private final BindingsPropertyDef2 parent;

    BindingsPropertyDef2(JWSModelElement<JWS_MODEL_TYPE, WSDL_MODEL_TYPE, BINDINGS_MODEL_TYPE> modelElement, ValueProperty bindings, ValueProperty wsdl, ValueProperty jws) {
        this(modelElement, bindings, wsdl, jws, null);
    }

    BindingsPropertyDef2(JWSModelElement<JWS_MODEL_TYPE, WSDL_MODEL_TYPE, BINDINGS_MODEL_TYPE> modelElement, ValueProperty bindings, ValueProperty wsdl, ValueProperty jws, BindingsPropertyDef2 parentBindingProperty) {
        this.jwsElement = modelElement;
        this.wsdlPropertyDef = wsdl;
        this.bindingsPropertyDef = bindings;
        this.jwsPropertyDef = jws;
        this.parent = parentBindingProperty;
        assert (this.parent == null || this.parent.bindingsPropertyDef.getModelElementType() == this.bindingsPropertyDef.getModelElementType());
        if (this.parent != null) {
            this.parent.setChildBinding(this);
        }
    }

    private void setChildBinding(BindingsPropertyDef2 bindingsPropertyDef2) {
        this.child = bindingsPropertyDef2;
    }

    public String get() {
        WSDL_MODEL_TYPE wsdlElement;
        String value = null;
        if (this.wsdlPropertyDef != null && (wsdlElement = this.jwsElement.getWsdlModelElement()) != null) {
            value = wsdlElement.property(this.wsdlPropertyDef).text(false);
        }
        for (IBindingsElement item : this.jwsElement.getBindingsElements()) {
            if (item != null) {
                value = item.property(this.bindingsPropertyDef).text(false);
            }
            if (value != null) break;
        }
        return value;
    }

    public void set(Object o) {
        if (o == null && this.child != null) {
            this.child.set(null);
        }
        IBindingsElement oldItem = null;
        for (IBindingsElement item : this.jwsElement.getBindingsElements()) {
            Value parentObject;
            if (item == null) continue;
            Value bv = item.property(this.bindingsPropertyDef);
            if (bv.content(false) != null) {
                oldItem = item;
                break;
            }
            if (this.parent == null || (parentObject = item.property(this.parent.bindingsPropertyDef)).content(false) == null) continue;
            oldItem = item;
            break;
        }
        if (oldItem == null && o != null) {
            oldItem = (IBindingsElement)this.jwsElement.createNewBindings();
            if (this.parent != null) {
                Element modelElement = this.parent.jwsElement.getModelElement();
                String value = modelElement.property(this.parent.jwsPropertyDef).text();
                oldItem.property(this.parent.bindingsPropertyDef).write((Object)value);
            }
        }
        if (oldItem != null) {
            oldItem.property(this.bindingsPropertyDef).write((Object)(o == null ? null : String.valueOf(o)));
            if (o == null) {
                XmlResource xmlResource = (XmlResource)oldItem.resource();
                XmlElement xml = xmlResource.getXmlElement();
                List childXml = xml.getChildElements();
                boolean isEmpty = true;
                for (XmlElement child : childXml) {
                    if (child.getDomNode().getNodeType() == 3) continue;
                    isEmpty = false;
                    break;
                }
                if (isEmpty) {
                    xml.remove();
                }
            }
        }
    }
}

