/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.internal.NodeNameBinding;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelGroupResource;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.xml.StandardXmlListBindingImpl;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;

public abstract class BindingsModelListController<LAYERED_MODEL extends Element, PARENT_MODEL extends Element, BINDINGS_MODEL extends Element, WSDL_MODEL extends Element>
extends StandardXmlListBindingImpl {
    private final JWSModelGroupResource group;
    private final IFilter bindingsFilter;
    private final IFilter wsdlFilter;
    private final ValueProperty modelNameProperty;
    private final ValueProperty bindingNameProperty;
    private final ValueProperty wsdlNameProperty;
    private final ListProperty bindingsListProperty;
    private final ListProperty wsdlListProperty;
    private final ListKeyPropertyPair[] wsdllkpp;
    private final BindingsListNodePattern pattern;

    public BindingsModelListController(JWSModelGroupResource group, IFilter bindingsFilter, IFilter wsdlFilter, BindingsListNodePattern pattern, ValueProperty modelNameProperty, ValueProperty bindingNameProperty, ValueProperty wsdlNameProperty, ListProperty bindingsListProperty, ListProperty wsdlListProperty, ListKeyPropertyPair ... lkpp) {
        this.group = group;
        this.bindingsFilter = bindingsFilter;
        this.wsdlFilter = wsdlFilter;
        this.modelNameProperty = modelNameProperty;
        this.bindingNameProperty = bindingNameProperty;
        this.wsdlNameProperty = wsdlNameProperty;
        this.bindingsListProperty = bindingsListProperty;
        this.wsdlListProperty = wsdlListProperty;
        this.wsdllkpp = lkpp;
        this.pattern = pattern;
        assert (bindingsListProperty.getModelElementType() == IBindingsSet.TYPE);
    }

    public final List<LAYERED_MODEL> refresh(List<LAYERED_MODEL> contents) {
        HashMap<String, Element> previous = new HashMap<String, Element>(contents.size());
        for (Element model : contents) {
            String name = BindingsModelListController.getString(this.modelNameProperty, model);
            previous.put(name, model);
        }
        ArrayList list = new ArrayList(contents.size());
        ModelListMapper bindingsMapper = new ModelListMapper(this.bindingsListProperty, this.bindingNameProperty, this.bindingsFilter);
        ModelListMapper wsdlMapper = new ModelListMapper(this.wsdlListProperty, this.wsdlNameProperty, this.wsdlFilter);
        Map mappedBindings = bindingsMapper.listToMap(this.group.getBindingsSet());
        IWsdlModel wsdl = this.group.getWsdlModel();
        if (wsdl != null) {
            IWsdlModel me = this.wsdllkpp == null ? wsdl : BindingsModelListController.findElement(wsdl, this.wsdllkpp);
            Map mappedWsdlBindings = wsdlMapper.listToMap(me);
            for (Map.Entry entry : mappedWsdlBindings.entrySet()) {
                String name = (String)entry.getKey();
                mappedBindings.remove(name);
                this.createAndAddToList(name, previous, list);
            }
        }
        for (Map.Entry entry : mappedBindings.entrySet()) {
            this.createAndAddToList(entry.getKey(), previous, list);
        }
        IBindingsSet bindingsModel = this.group.getBindingsSet();
        for (String s : this.pattern.processLists(bindingsModel)) {
            this.createAndAddToList(s, previous, list);
        }
        return list;
    }

    public static Element findElement(Element root, ListKeyPropertyPair ... pairs) {
        Element element = root;
        int i = 0;
        while (i < pairs.length) {
            if (element == null) {
                return null;
            }
            element = pairs[i].applyFilter(element);
            ++i;
        }
        return element;
    }

    private void createAndAddToList(String name, Map<String, LAYERED_MODEL> previous, List<LAYERED_MODEL> list) {
        Object model = (Element)previous.get(name);
        if (model == null) {
            model = this.create(this.group, name);
            previous.put(name, model);
        }
        if (!list.contains(model)) {
            list.add(model);
        }
    }

    protected static String getString(ValueProperty p, Element m) {
        if (m == null) {
            return null;
        }
        Value v = m.property(p);
        return v == null ? null : v.text(false);
    }

    protected abstract LAYERED_MODEL create(JWSModelGroupResource var1, String var2);

    public final LAYERED_MODEL createNewElement(ElementType type) {
        return this.create(this.group, "");
    }

    public static final class BindingsListNodePattern {
        private final NodeNameBinding.Patterns pattern;
        private final ListProperty[] properties;

        public BindingsListNodePattern(NodeNameBinding.Patterns pattern, ListProperty ... properties) {
            this.pattern = pattern;
            this.properties = properties;
        }

        public List<String> processLists(IBindingsSet bindings) {
            ArrayList<String> values = new ArrayList<String>();
            ListProperty[] listPropertyArray = this.properties;
            int n = this.properties.length;
            int n2 = 0;
            while (n2 < n) {
                ListProperty property = listPropertyArray[n2];
                for (Element modelElement : bindings.property(property)) {
                    XmlResource xmlResource = (XmlResource)modelElement.resource();
                    XmlElement xml = xmlResource.getXmlElement();
                    if (!this.pattern.applies(xml)) continue;
                    values.add(this.pattern.getValue(xml));
                }
                ++n2;
            }
            return values;
        }
    }

    public static final class HierarchyNavigator {
        private final ListKeyPropertyPair[] keyPropertyPairs;

        public HierarchyNavigator(ListKeyPropertyPair ... keyPropertyPairs) {
            this.keyPropertyPairs = keyPropertyPairs;
        }

        public Element getElement(Element model) {
            Element current = model;
            int i = 0;
            while (i < this.keyPropertyPairs.length) {
                ElementList l = current.property(this.keyPropertyPairs[i].list);
                for (Element element : l) {
                    if (!this.keyPropertyPairs[i].filter.filter(element)) continue;
                    return element;
                }
                ++i;
            }
            return null;
        }
    }

    public static interface IFilter {
        public boolean filter(Element var1);
    }

    public static final class KeyPropertyFilter
    implements IFilter {
        private final ValueProperty prop;
        private final String value;

        public KeyPropertyFilter(ValueProperty p, String v) {
            assert (p != null);
            assert (v != null);
            this.prop = p;
            this.value = v;
        }

        @Override
        public boolean filter(Element e) {
            assert (this.prop.getModelElementType() == e.type()) : String.valueOf(this.prop.getModelElementType().getModelElementClass().getSimpleName()) + " != " + e.type().getModelElementClass().getSimpleName();
            String elementValue = BindingsModelListController.getString(this.prop, e);
            return elementValue != null && elementValue.equals(this.value);
        }
    }

    public static final class ListKeyPropertyPair {
        final ListProperty list;
        final IFilter filter;

        public ListKeyPropertyPair(ListProperty l, IFilter f) {
            this.list = l;
            this.filter = f;
        }

        public Element applyFilter(Element e) {
            assert (this.list.getModelElementType() == e.type());
            ElementList l = e.property(this.list);
            for (Element me : l) {
                if (!this.filter.filter(me)) continue;
                return me;
            }
            return null;
        }
    }

    private static final class ModelListMapper<T extends Element> {
        private final ListProperty prop;
        private final IFilter filter;
        private final ValueProperty mappedProperty;

        ModelListMapper(ListProperty listProperty, ValueProperty mappingProperty, IFilter filter) {
            this.prop = listProperty;
            this.filter = filter;
            this.mappedProperty = mappingProperty;
        }

        public Map<String, T> listToMap(Element root) {
            if (root == null) {
                return Collections.emptyMap();
            }
            assert (this.prop.getModelElementType() == root.type());
            ElementList elements = root.property(this.prop);
            LinkedHashMap<String, Element> mappedElements = new LinkedHashMap<String, Element>(elements.size());
            for (Element element : elements) {
                if (this.filter != null && !this.filter.filter(element)) continue;
                String name = BindingsModelListController.getString(this.mappedProperty, element);
                mappedElements.put(name, element);
            }
            return mappedElements;
        }
    }

    public static final class ParentKeyPropertyFilter
    implements IFilter {
        private final ValueProperty prop;
        private final String value;

        public ParentKeyPropertyFilter(ValueProperty p, String v) {
            assert (p != null);
            assert (v != null);
            this.prop = p;
            this.value = v;
        }

        @Override
        public boolean filter(Element e) {
            Property parent = e.parent();
            assert (parent != null) : String.valueOf(this.prop.getModelElementType().getModelElementClass().getSimpleName()) + " for element parent of type " + e.type().getModelElementClass().getSimpleName();
            Element rootElement = parent.element();
            ElementType type = rootElement.type();
            assert (type != null) : String.valueOf(this.prop.getModelElementType().getModelElementClass().getSimpleName()) + " for element parent of type " + e.type().getModelElementClass().getSimpleName() + rootElement.getClass().getSimpleName();
            assert (this.prop.getModelElementType() == rootElement.type()) : String.valueOf(this.prop.getModelElementType().getModelElementClass().getSimpleName()) + " != " + rootElement.type().getModelElementClass().getSimpleName();
            String elementValue = BindingsModelListController.getString(this.prop, rootElement);
            return elementValue != null && elementValue.equals(this.value);
        }
    }
}

