/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;

public class ModelPropertyMapper<PROPERTY extends PropertyDef> {
    private Boolean rebroadcast = true;
    protected PROPERTY fromProperty;
    protected Element fromModel;
    protected PROPERTY toProperty;
    protected Element toModel;
    private final Listener listener;

    public ModelPropertyMapper(PROPERTY fromProperty, Element fromModel, final PROPERTY toProperty, final Element toModel) {
        this.fromProperty = fromProperty;
        this.fromModel = fromModel;
        this.toProperty = toProperty;
        this.toModel = toModel;
        this.listener = new FilteredListener<PropertyContentEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void handleTypedEvent(PropertyContentEvent event) {
                ModelPropertyMapper modelPropertyMapper = ModelPropertyMapper.this;
                synchronized (modelPropertyMapper) {
                    if (!ModelPropertyMapper.this.rebroadcast.booleanValue()) {
                        return;
                    }
                }
                if (!toModel.disposed()) {
                    toModel.property(toProperty).refresh();
                }
            }
        };
        this.fromModel.property(this.fromProperty).attach(this.listener);
    }

    protected void finalize() throws Throwable {
        this.fromModel.property(this.fromProperty).detach(this.listener);
        super.finalize();
    }

    public PROPERTY getFromProperty() {
        return this.fromProperty;
    }

    public Element getFromModel() {
        return this.fromModel;
    }

    public PROPERTY getToProperty() {
        return this.toProperty;
    }

    public Element getToModel() {
        return this.toModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRebroadcastEnabled(boolean enabled) {
        ModelPropertyMapper modelPropertyMapper = this;
        synchronized (modelPropertyMapper) {
            this.rebroadcast = enabled;
        }
    }
}

