/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.model.LightweightWsdlModel;
import oracle.eclipse.tools.webservices.model.WsdlParseFaildedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class WsdlModelValidator {
    private WsdlModelValidator() {
    }

    public static IStatus validate(IFile wsdl) {
        LightweightWsdlModel model;
        URI wsdlURI = wsdl.getLocation().toFile().toURI().normalize();
        try {
            model = new LightweightWsdlModel(wsdlURI);
        }
        catch (WsdlParseFaildedException e) {
            return new Status(4, "oracle.eclipse.tools.webservices", e.getMessage());
        }
        return WsdlModelValidator.validateModel(model);
    }

    public static IStatus validateModel(LightweightWsdlModel model) {
        Map<String, Collection<String>> bindings = model.getOperationalBindings();
        for (Map.Entry<String, Collection<String>> binding : bindings.entrySet()) {
            for (String s : binding.getValue()) {
                if (!"encoded".equalsIgnoreCase(s.trim())) continue;
                String message = Messages.bind((String)Messages.wsdlc_encoding_error, (Object)binding.getKey());
                return new Status(4, "oracle.eclipse.tools.webservices", message);
            }
        }
        return Status.OK_STATUS;
    }
}

