/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.jdt;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.jdt.FieldElement;
import oracle.eclipse.tools.webservices.jdt.JaxwsElement;
import oracle.eclipse.tools.webservices.jdt.JaxwsModel;
import oracle.eclipse.tools.webservices.jdt.MethodElement;
import oracle.eclipse.tools.webservices.jdt.annotation.BindingTypeAnnotation;
import oracle.eclipse.tools.webservices.jdt.annotation.WebServiceAnnotation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TypeElement
extends JaxwsElement {
    private TypeElement eiTypeElement;
    private static final String SERVICE = "Service";
    private List<MethodElement> methodElements;
    private List<FieldElement> fieldElements;
    private WebServiceAnnotation webServiceAnnotation;
    private BindingTypeAnnotation bindingTypeAnnotation;
    private final TypeDeclaration typeDeclaration;

    public TypeElement(JaxwsModel model, TypeDeclaration typeDeclaration) {
        super(model);
        this.typeDeclaration = typeDeclaration;
        this.initialize();
    }

    @Override
    protected void initialize() {
        String endPointInterface;
        this.webServiceAnnotation = new WebServiceAnnotation((Declaration)this.getTypeDeclaration());
        this.eiTypeElement = this;
        if (this.webServiceAnnotation.hasAnnotation() && !StringUtil.isEmpty((String)(endPointInterface = this.webServiceAnnotation.getEndpointInterface()))) {
            IJavaProject iJavaProject = this.getJaxwsModel().getJavaProject();
            try {
                TypeElement eiElement;
                WebServiceAnnotation eiAnnot;
                TypeDeclaration typeDeclaration;
                IType type = iJavaProject.findType(endPointInterface);
                if (type != null && (typeDeclaration = this.getJaxwsModel().getAnnotationProcessorEnv().getTypeDeclaration(type.getFullyQualifiedName())) != null && (eiAnnot = (eiElement = new TypeElement(this.getJaxwsModel(), typeDeclaration)).getWebServiceAnnotation()).hasAnnotation()) {
                    this.eiTypeElement = eiElement;
                }
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (CoreException)((Object)e));
            }
        }
        this.bindingTypeAnnotation = new BindingTypeAnnotation((Declaration)this.getTypeDeclaration());
        this.methodElements = new ArrayList<MethodElement>();
        Collection<? extends MethodDeclaration> methods = this.getMethodDeclarations();
        for (MethodDeclaration methodDeclaration : methods) {
            this.methodElements.add(new MethodElement(this, methodDeclaration));
        }
        this.fieldElements = new ArrayList<FieldElement>();
        Collection<FieldDeclaration> collection = this.getFieldDeclarations();
        for (FieldDeclaration field : collection) {
            this.fieldElements.add(new FieldElement(this, field));
        }
    }

    public String getSimpleName() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getSimpleName();
        }
        return "";
    }

    public String getQualifiedName() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getQualifiedName();
        }
        return "";
    }

    public TypeDeclaration getTypeDeclaration() {
        return this.typeDeclaration;
    }

    public WebServiceAnnotation getWebServiceAnnotation() {
        return this.webServiceAnnotation;
    }

    public BindingTypeAnnotation getBindingTypeAnnotation() {
        return this.bindingTypeAnnotation;
    }

    public TypeElement getEiTypeElement() {
        return this.eiTypeElement;
    }

    public List<MethodElement> getMethodElements() {
        return this.methodElements;
    }

    public List<FieldElement> getFieldElements() {
        return this.fieldElements;
    }

    private Collection<? extends MethodDeclaration> getMethodDeclarations() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getMethods();
        }
        return Collections.emptyList();
    }

    private Collection<FieldDeclaration> getFieldDeclarations() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getFields();
        }
        return Collections.emptyList();
    }

    @Override
    public String getUrlSegment() {
        String serviceName;
        if (this.webServiceAnnotation.hasAnnotation() && (serviceName = this.webServiceAnnotation.getServiceName()) != null && serviceName.length() != 0) {
            return serviceName;
        }
        return String.valueOf(this.getSimpleName()) + SERVICE;
    }

    public List<MethodElement> findPostMethods() {
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>();
        for (MethodElement method : this.methodElements) {
            if (!method.getPostAnnotation().hasAnnotation()) continue;
            methods.add(method);
        }
        return methods;
    }

    @Override
    public String getFullUrlSegment() {
        return this.formatUrl(this.getUrlSegment());
    }
}

