/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.jdt;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.webservices.jdt.JaxwsElement;
import oracle.eclipse.tools.webservices.jdt.ParameterElement;
import oracle.eclipse.tools.webservices.jdt.annotation.WebMethodAnnotation;
import oracle.eclipse.tools.webservices.jdt.annotation.WebServiceRefAnnotation;

public class MethodElement
extends JaxwsElement {
    private final MethodDeclaration methodDeclaration;
    private final JaxwsElement parent;
    private List<ParameterElement> parameterElements;
    private WebServiceRefAnnotation webServiceRefAnnotation;
    private WebMethodAnnotation webMethodAnnotation;

    public MethodElement(JaxwsElement parent, MethodDeclaration methodDeclaration) {
        super(parent.getJaxwsModel());
        this.parent = parent;
        this.methodDeclaration = methodDeclaration;
        this.initialize();
    }

    @Override
    protected void initialize() {
        this.webMethodAnnotation = new WebMethodAnnotation((Declaration)this.getMethodDeclaration());
        this.webServiceRefAnnotation = new WebServiceRefAnnotation((Declaration)this.getMethodDeclaration());
        this.parameterElements = new ArrayList<ParameterElement>();
        Collection<ParameterDeclaration> parameters = this.getParameterDeclarations();
        for (ParameterDeclaration parameter : parameters) {
            this.parameterElements.add(new ParameterElement(this, parameter));
        }
    }

    public MethodDeclaration getMethodDeclaration() {
        return this.methodDeclaration;
    }

    public WebServiceRefAnnotation getPathAnnotation() {
        return this.webServiceRefAnnotation;
    }

    public WebMethodAnnotation getPostAnnotation() {
        return this.webMethodAnnotation;
    }

    protected Collection<ParameterDeclaration> getParameterDeclarations() {
        if (this.getMethodDeclaration() != null) {
            return this.getMethodDeclaration().getParameters();
        }
        return Collections.emptyList();
    }

    public List<ParameterElement> getParameterElements() {
        return this.parameterElements;
    }

    @Override
    public String getFullUrlSegment() {
        return this.parent.getFullUrlSegment();
    }

    @Override
    public String getUrlSegment() {
        return "";
    }
}

