/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.jaxb;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class JaxbXJCArguments
extends CommonWebServiceAntTaskArguments {
    private IFile destFile;
    private File targetDir;
    private final List<IFile> schemas = new ArrayList<IFile>();
    private final List<IFolder> xsdFolders = new ArrayList<IFolder>();
    private final List<IFolder> xjbFolders = new ArrayList<IFolder>();
    private IFile catalog;
    private Boolean looseValidation;
    private Boolean header = true;
    private Boolean includeSourceInJar = false;

    public File getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public boolean getGenSrc() {
        return this.isGenSrc();
    }

    public boolean isGenSrc() {
        return this.destFile != null && this.destFile.getFileExtension() != null && this.destFile.getFileExtension().compareToIgnoreCase("jar") != 0;
    }

    public Boolean getLooseValidation() {
        return this.looseValidation;
    }

    public void setLooseValidation(Boolean looseValidation) {
        this.looseValidation = looseValidation;
    }

    public Boolean getHeader() {
        return this.header;
    }

    public void setHeader(Boolean header) {
        this.header = header;
    }

    public Boolean getIncludeSourceInJar() {
        return this.includeSourceInJar;
    }

    public void setIncludeSourceInJar(Boolean b) {
        this.includeSourceInJar = b;
    }

    public IFile getDestFile() {
        return this.destFile;
    }

    public void setDestFile(IFile destFile) {
        this.destFile = destFile;
    }

    public List<IFile> getSchemas() {
        return this.schemas;
    }

    public IFile getFirstSchema() {
        return this.schemas.size() > 0 ? this.schemas.get(0) : null;
    }

    public void clearSchemas() {
        this.schemas.clear();
    }

    public final void addSchema(IFile schema) {
        if (schema != null && !this.schemas.contains(schema)) {
            this.schemas.add(schema);
        }
    }

    public final void setSchemas(List<IFile> schemaList) {
        this.schemas.clear();
        this.schemas.addAll(schemaList);
    }

    public void removeSchema(IFile item) {
        this.schemas.remove(item);
    }

    public List<IFolder> getXsdFolders() {
        return this.xsdFolders;
    }

    public IFolder getXsdFirstFolder() {
        return this.xsdFolders.size() > 0 ? this.xsdFolders.get(0) : null;
    }

    public void clearXsdFolders() {
        this.xsdFolders.clear();
    }

    public final void addXsdFolder(IFolder folder) {
        if (folder != null && !this.xsdFolders.contains(folder)) {
            this.xsdFolders.add(folder);
        }
    }

    public void removeXsdFolder(IFolder item) {
        this.xsdFolders.remove(item);
    }

    public List<IFolder> getXjbFolders() {
        return this.xjbFolders;
    }

    public IFolder getXjbFirstFolder() {
        return this.xjbFolders.size() > 0 ? this.xjbFolders.get(0) : null;
    }

    public void clearXjbFolders() {
        this.xjbFolders.clear();
    }

    public final void addXjbFolder(IFolder folder) {
        if (folder != null && !this.xjbFolders.contains(folder)) {
            this.xjbFolders.add(folder);
        }
    }

    public void removeXjbFolder(IFolder item) {
        this.xjbFolders.remove(item);
    }

    public IFile getCatalog() {
        return this.catalog;
    }

    public void setCatalog(IFile catalog) {
        this.catalog = catalog;
    }

    public String getCatalogAsString() {
        return this.catalog == null ? null : this.catalog.getProjectRelativePath().toPortableString();
    }

    @Override
    public void setProject(IProject project) {
        super.setProject(project);
    }

    @Override
    public boolean shouldInsertClasspath() {
        boolean result = this.getXjbFolders().size() > 0 || super.shouldInsertClasspath();
        return result;
    }

    public String[] iFilesToProjectRelativeStringArray(Collection<? extends IResource> files) {
        ArrayList<String> strings = new ArrayList<String>();
        for (IResource iResource : files) {
            strings.add(iResource.getProjectRelativePath().toPortableString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public String[] getSchemasRelativeToProject() {
        return this.iFilesToProjectRelativeStringArray(this.schemas);
    }

    public String[] getXsdFoldersRelativeToProject() {
        return this.iFilesToProjectRelativeStringArray(this.xsdFolders);
    }

    public String[] getBindingsRelativeToProject() {
        return this.iFilesToProjectRelativeStringArray(this.getBindings());
    }

    public String[] getXjbFoldersRelativeToProject() {
        return this.iFilesToProjectRelativeStringArray(this.xjbFolders);
    }
}

