/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.export;

import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.compiler.WebServiceProjectCompiler;
import oracle.eclipse.tools.webservices.export.AbstractExportOperation;
import oracle.eclipse.tools.webservices.runtimes.WSRuntime;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public final class PreExportOperation
extends AbstractExportOperation {
    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }

    @Override
    protected void processModule(IProgressMonitor monitor, IProject project) throws ExecutionException {
        if (!WebServiceProject.isWebServiceProject(project)) {
            return;
        }
        WSRuntime runtime = (WSRuntime)((Object)project.getAdapter(WSRuntime.class));
        if (runtime == null) {
            this.showExportedEarOrWarNoGoodDialogIfNotShownDuringThisExport();
            return;
        }
        WebServiceProjectCompiler builder = runtime.getWebServiceProjectCompiler();
        try {
            try {
                builder.build(monitor);
            }
            catch (Exception e) {
                String msg = Messages.bind((String)Messages.export_operation_error_build, (Object)project.getName());
                throw new ExecutionException(msg, (Throwable)e);
            }
        }
        finally {
            runtime.close();
        }
    }
}

