/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.compiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import org.eclipse.jst.ws.jaxws.core.utils.WSDLUtils;

public class WsdlDefinitionReader {
    private ClassLoader cl = null;
    private File cowFile;
    private Map<String, Definition> definitions = new HashMap<String, Definition>();

    WsdlDefinitionReader(File cowFile) {
        this.cowFile = cowFile;
        this.cl = WsdlDefinitionReader.getCowClassLoader(cowFile);
    }

    private static URLClassLoader getCowClassLoader(File cowFile) {
        URL url = null;
        try {
            url = cowFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("compileWsdl file " + cowFile.getAbsolutePath() + "is invalid.", e);
        }
        URLClassLoader classLoader = new URLClassLoader(new URL[]{url}, null);
        return classLoader;
    }

    public Definition getWsdl(String wsdlLocation) throws Exception {
        if (wsdlLocation.startsWith("/")) {
            wsdlLocation = wsdlLocation.substring(1);
        }
        if (this.definitions.containsKey(wsdlLocation)) {
            return this.definitions.get(wsdlLocation);
        }
        URL wsdlUrl = this.cl.getResource(wsdlLocation);
        if (wsdlUrl == null) {
            throw new Exception("wsdl was not found in compiledWsdl file at: " + wsdlLocation);
        }
        Definition wsdl = WSDLUtils.readWSDL((URL)wsdlUrl);
        this.definitions.put(wsdlLocation, wsdl);
        return wsdl;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public File getCowFile() {
        return this.cowFile;
    }

    public void cleanup() {
        this.cl = null;
    }
}

