/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.compiler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.compiler.Jws;
import oracle.eclipse.tools.webservices.compiler.PortInfo;
import org.eclipse.core.runtime.Plugin;

public class PortInfoFactory {
    private final Jws jws;
    private final QName serviceName;
    private String portName = null;
    private String wsdlLocation = null;
    private String contextPath = null;
    private String protocol = "http";

    public PortInfoFactory(Jws jws, QName serviceName, String portName) {
        this.jws = jws;
        this.serviceName = serviceName;
        this.portName = portName;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Set<PortInfo> buildPorts() {
        Set<PortInfo> ports = this.getPorts();
        this.normalizePorts(ports);
        return ports;
    }

    private void normalizePorts(Set<PortInfo> ports) {
        HashSet<PortInfo> unnamedPorts = new HashSet<PortInfo>();
        for (PortInfo portDecl : ports) {
            this.normalizePort(portDecl, unnamedPorts);
        }
        this.namePorts(unnamedPorts);
    }

    private void normalizePort(PortInfo portDecl, Set<PortInfo> unnamedPorts) {
        if (portDecl != null) {
            portDecl.setContextPath(this.normalizeContextPath(portDecl.getPortName(), portDecl.getContextPath()));
            portDecl.setServiceUri(this.normalizeServiceUri(portDecl.getServiceUri()));
            portDecl.setProtocol(this.protocol);
            if (StringUtil.isEmpty((String)portDecl.getPortName())) {
                unnamedPorts.add(portDecl);
            } else {
                portDecl.setPortName(portDecl.getPortName().trim());
            }
        }
    }

    private void namePorts(Set<PortInfo> unnamedPorts) {
        if (unnamedPorts.size() == 1) {
            PortInfo port = unnamedPorts.iterator().next();
            port.setPortName(this.portName);
        } else {
            Iterator<PortInfo> iterator = unnamedPorts.iterator();
            while (iterator.hasNext()) {
                PortInfo portDecl;
                PortInfo port = portDecl = iterator.next();
                port.setPortName(String.valueOf(this.portName) + port.getProtocol());
            }
        }
    }

    private Set<PortInfo> getPorts() {
        HashSet<PortInfo> ports = new HashSet<PortInfo>();
        if (this.jws.getPorts().hasNext()) {
            Iterator<PortInfo> iter = this.jws.getPorts();
            while (iter.hasNext()) {
                ports.add(iter.next());
            }
        }
        if (ports.size() == 0 && !StringUtil.isEmpty((String)this.wsdlLocation) && this.jws.getWsdlReader() != null) {
            this.loadWsdlPorts(ports);
        }
        if (ports.size() == 0) {
            this.addDefaultPorts(ports);
        }
        return ports;
    }

    private void addDefaultPorts(Set<PortInfo> ports) {
        ports.add(new PortInfo());
    }

    private void loadWsdlPorts(Set<PortInfo> ports) {
        Service service;
        Definition definitions = null;
        try {
            definitions = this.jws.getWsdlReader().getWsdl(this.wsdlLocation);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e, (String)("cow.wsdl.invalid: " + this.wsdlLocation));
        }
        if (definitions != null && (service = definitions.getService(this.serviceName)) != null) {
            Map portsMap = service.getPorts();
            Set portsSet = portsMap.entrySet();
            for (Map.Entry portEntry : portsSet) {
                Port port = (Port)portEntry.getValue();
                String loc = this.getSOAPAddressLocation(port);
                if (loc == null) continue;
                if ("REPLACE_WITH_ACTUAL_URL".equals(loc)) {
                    loc = String.valueOf(this.protocol) + "://localhost/" + (this.contextPath != null ? String.valueOf(this.contextPath) + "/" : "") + this.serviceName.getLocalPart() + "/" + this.portName;
                }
                try {
                    URL url = new URL(loc);
                    PortInfo portDecl = PortInfoFactory.newPort(url, port);
                    ports.add(portDecl);
                }
                catch (MalformedURLException e) {
                    LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e, (String)("port.cow.invalidAddressLocation: " + loc));
                }
            }
        }
    }

    private String getSOAPAddressLocation(Port port) {
        List extensibilityElements = port.getExtensibilityElements();
        for (Object object : extensibilityElements) {
            if (object instanceof SOAPAddress) {
                return ((SOAPAddress)object).getLocationURI();
            }
            if (!(object instanceof SOAP12Address)) continue;
            return ((SOAP12Address)object).getLocationURI();
        }
        return null;
    }

    private String normalizeServiceUri(String uri) {
        String normalized = null;
        normalized = uri == null ? this.serviceName.getLocalPart() : uri;
        return PortInfo.normalizePath(normalized);
    }

    private String normalizeContextPath(String portName, String path) {
        String normalized = null;
        if (this.contextPath != null) {
            normalized = this.contextPath;
            if (path != null) {
                LoggingService.logWarning((Plugin)WebServicesCorePlugin.getDefault(), (String)("port.overrideContextPath: " + this.serviceName + ", " + portName + ", " + path + ", " + this.contextPath));
            }
        } else {
            normalized = path != null ? path : this.jws.getSimpleName();
        }
        if ((normalized = normalized.replace('\\', '/')).endsWith("/")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        return normalized;
    }

    public static PortInfo newPort(URL url, Port port) {
        PortInfo portDecl = new PortInfo(url.getFile(), "", "");
        Binding binding = port.getBinding();
        portDecl.setContextPath(url.getFile());
        portDecl.setServiceUri("");
        if (binding != null && binding.getQName() != null) {
            portDecl.setPortName(binding.getQName().getLocalPart());
        }
        return portDecl;
    }
}

