/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.SourcePosition;
import java.util.List;
import oracle.eclipse.tools.webservices.WebServicesException;
import oracle.eclipse.tools.webservices.compiler.InvalidWebServiceException;
import oracle.eclipse.tools.webservices.compiler.Jws;
import oracle.eclipse.tools.webservices.jdt.JaxwsContext;
import oracle.eclipse.tools.webservices.jdt.JaxwsModel;
import oracle.eclipse.tools.webservices.jdt.TypeElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.apt.core.env.EnvironmentFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;

public final class JwsFactory {
    private IFile mirrorTypeFile;
    private JaxwsModel jaxwsModel;

    public JwsFactory(ICompilationUnit unit) throws WebServicesException, InvalidWebServiceException {
        IType type = unit.findPrimaryType();
        IJavaProject javaProject = unit.getJavaProject();
        if (type == null) {
            throw InvalidWebServiceException.InvalidServiceReason.JAVA_ERROR.exception(unit.getElementName());
        }
        AnnotationProcessorEnvironment env = EnvironmentFactory.getEnvironment((ICompilationUnit)unit, (IJavaProject)javaProject);
        TypeDeclaration mirrorType = env.getTypeDeclaration(type.getFullyQualifiedName());
        if (mirrorType == null) {
            throw InvalidWebServiceException.InvalidServiceReason.JAVA_ERROR.exception(unit.getElementName());
        }
        this.mirrorTypeFile = JwsFactory.findFile(mirrorType);
        if (this.mirrorTypeFile == null) {
            throw InvalidWebServiceException.InvalidServiceReason.NO_FILE.exception(mirrorType.getQualifiedName());
        }
        JaxwsContext jaxwsContext = new JaxwsContext((IJavaElement)unit);
        this.jaxwsModel = new JaxwsModel(jaxwsContext);
    }

    public IFile getTypeFile() {
        return this.mirrorTypeFile;
    }

    public Jws createJws() {
        List<TypeElement> typeElements = this.jaxwsModel.getTypeElements();
        for (TypeElement typeElement : typeElements) {
            if (!typeElement.getWebServiceAnnotation().hasAnnotation()) continue;
            return new Jws(typeElement, this.jaxwsModel, false);
        }
        return null;
    }

    private static IFile findFile(TypeDeclaration type) {
        SourcePosition pos = type.getPosition();
        if (pos == null || pos.file() == null) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] typeFiles = workspaceRoot.findFilesForLocationURI(pos.file().toURI());
        if (typeFiles.length == 0) {
            return null;
        }
        IFile[] iFileArray = typeFiles;
        int n = typeFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile f = iFileArray[n2];
            if (f.exists()) {
                return f;
            }
            ++n2;
        }
        return null;
    }
}

