/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.jdt.ClasspathUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WlsRuntimeClassLoader;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;

public final class CompileGeneratedFilesRunnable
implements Runnable {
    private final IProject project;
    private final IFolder srcFolder;
    private final IFolder classFolder;

    public CompileGeneratedFilesRunnable(IProject project, IFolder srcFolder, IFolder classFolder) {
        if (project == null || srcFolder == null || classFolder == null) {
            throw new NullPointerException("Neither project, srcFolder or classFolder can be null.");
        }
        this.project = project;
        this.srcFolder = srcFolder;
        this.classFolder = classFolder;
    }

    @Override
    public void run() {
        try {
            this.compileGeneratedFiles();
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (CoreException)ce);
            DialogService.showErrorDialog((String)Messages.compiler_failure_msg);
        }
    }

    protected void appendWLSClassPath(List<IPath> cp) {
        WlsRuntimeClassLoader builder = (WlsRuntimeClassLoader)this.project.getAdapter(WlsRuntimeClassLoader.class);
        URL[] uRLArray = builder.getURLs();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            cp.add((IPath)new Path(url.getPath()));
            ++n2;
        }
    }

    private void runCompiler(String args) {
        PrintStream origErrStream = System.err;
        InfoLoggerStreamWrapper logWrapper = new InfoLoggerStreamWrapper();
        boolean compileSuccess = false;
        try {
            try {
                System.setErr(new PrintStream((OutputStream)logWrapper, false, StandardCharsets.UTF_8.name()));
                compileSuccess = BatchCompiler.compile((String)args, (PrintWriter)new PrintWriter(System.out), (PrintWriter)new PrintWriter(System.err), null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logWrapper.flush();
                if (!compileSuccess) {
                    DialogService.showErrorDialog((String)Messages.compiler_failure_msg);
                }
                System.setErr(origErrStream);
            }
        }
        finally {
            logWrapper.flush();
            if (!compileSuccess) {
                DialogService.showErrorDialog((String)Messages.compiler_failure_msg);
            }
            System.setErr(origErrStream);
        }
    }

    private void compileGeneratedFiles() throws CoreException {
        IJavaProject jp = JavaCore.create((IProject)this.project);
        List cp = ClasspathUtil.createClasspath((IJavaProject)jp);
        this.appendWLSClassPath(cp);
        IPath fqSrcFolder = this.srcFolder.getLocation();
        cp.add(fqSrcFolder);
        IPath fqOutputFolder = this.classFolder.getLocation();
        StringBuilder args = new StringBuilder();
        args.append('\"').append(fqSrcFolder.toFile().getAbsolutePath()).append('\"').append(" -classpath \"").append(ClasspathUtil.createClasspathString((List)cp)).append('\"').append(" -1.5").append(" -nowarn").append(" -d ").append('\"').append(fqOutputFolder.toFile().getAbsolutePath()).append('\"');
        this.runCompiler(args.toString());
    }

    private static class InfoLoggerStreamWrapper
    extends OutputStream {
        private boolean hasMessages = false;
        private StringBuffer buffer = null;

        private InfoLoggerStreamWrapper() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            this.buffer.append((char)b);
            if (b == 10) {
                this.writeToMessageLog();
            }
            this.hasMessages = true;
        }

        public boolean hasMessages() {
            return this.hasMessages;
        }

        @Override
        public void flush() {
            if (this.buffer != null) {
                this.writeToMessageLog();
            }
        }

        private void writeToMessageLog() {
            assert (this.buffer != null);
            LoggingService.logInfo((Plugin)WebServicesCorePlugin.getDefault(), (String)this.buffer.toString());
            this.buffer = null;
        }
    }
}

