/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.clientgen;

import com.bea.wlw.template.TemplateBeanAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskTemplateBean;
import oracle.eclipse.tools.webservices.clientgen.ClientGenArguments;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ClientGenTemplateBean
extends CommonWebServiceAntTaskTemplateBean {
    private ClientGenArguments arguments;

    public ClientGenTemplateBean(ClientGenArguments args) {
        super(args);
        this.arguments = args;
    }

    public boolean isRemoteWsdl() {
        return this.arguments.getWsdlIFile() == null;
    }

    public String getHandlerChainFile() {
        return this.arguments.getHandlerChain();
    }

    public String getServiceName() {
        return this.arguments.getServiceName();
    }

    public String getTrustStore() {
        return this.arguments.getTrustStore();
    }

    public List<SystemPropertyTemplateBean> getSystemProperties() {
        ArrayList<SystemPropertyTemplateBean> sysprops = new ArrayList<SystemPropertyTemplateBean>();
        for (Map.Entry<String, String> entry : this.arguments.getSystemProperties().entrySet()) {
            sysprops.add(new SystemPropertyTemplateBean(entry.getKey(), entry.getValue()));
        }
        return sysprops;
    }

    public Collection<String> getBindings() {
        return this.iFilesToProjectRelativeStrings(this.arguments.getBindings());
    }

    public String getWsdl() {
        return this.arguments.getWsdlPathAsString();
    }

    public boolean isAutoDetectWrapped() {
        return this.arguments.isAutoDetectWrapped();
    }

    public boolean isGenerateAsyncMethods() {
        return this.arguments.isGenerateAsyncMethods();
    }

    public boolean isGeneratePolicyMethods() {
        return this.arguments.isGeneratePolicyMethods();
    }

    public boolean isIncludeGlobalTypes() {
        return this.arguments.isIncludeGlobalTypes();
    }

    public boolean isJaxRpcWrappedArrayStyle() {
        return this.arguments.isJaxRpcArrayStyle();
    }

    public boolean isJaxRpc() {
        return false;
    }

    public boolean isDestFileAbsolute() {
        return this.getRelativeDestFile() == null;
    }

    public String getDestFile() {
        IPath relativeDestFile = this.getRelativeDestFile();
        if (relativeDestFile == null) {
            relativeDestFile = this.arguments.getDestFile().getLocation();
        }
        return relativeDestFile.toPortableString();
    }

    private IPath getRelativeDestFile() {
        IFile file = this.arguments.getDestFile();
        if (file.getProject() == this.arguments.getProject()) {
            return file.getProjectRelativePath();
        }
        return ClientGenTemplateBean.relativeLocation(this.arguments.getProject().getLocation(), file.getLocation());
    }

    public static IPath relativeLocation(IPath absoluteLocationFrom, IPath absoluteLocationTo) {
        if (absoluteLocationFrom.getDevice() == null && absoluteLocationTo.getDevice() != null || absoluteLocationFrom.getDevice() != null && absoluteLocationTo.getDevice() == null) {
            return null;
        }
        if (absoluteLocationFrom.getDevice() != null && absoluteLocationTo.getDevice() != null && !absoluteLocationFrom.getDevice().equals(absoluteLocationTo.getDevice())) {
            return null;
        }
        int matchingSegmentCount = absoluteLocationFrom.matchingFirstSegments(absoluteLocationTo);
        int totalFromSeqmentCount = absoluteLocationFrom.segmentCount();
        int delatCount = totalFromSeqmentCount - matchingSegmentCount;
        StringBuffer prePendString = new StringBuffer();
        int i = 0;
        while (i < delatCount) {
            prePendString.append("../");
            ++i;
        }
        Path path = new Path(prePendString.toString());
        return path.append(absoluteLocationTo.removeFirstSegments(matchingSegmentCount));
    }

    public boolean getCopyWsdl() {
        return this.arguments.getCopyWsdl();
    }

    public String getWsdlLocation() {
        return this.arguments.getNoCopyWsdl() ? null : this.arguments.getWsdlLocation();
    }

    public String getXmlCatalogFile() {
        return this.arguments.getXmlCatalogFileAsString();
    }

    public static class SystemPropertyTemplateBean
    extends TemplateBeanAdapter {
        private String key;
        private String value;

        public SystemPropertyTemplateBean(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

