/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ant;

import com.bea.wlw.template.ITemplateBean;
import com.bea.wlw.template.exceptions.GenerationFailedException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.templating.template.core.TemplateService;
import oracle.eclipse.tools.common.util.fileio.FolderUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.ant.AntScriptCreationFailedException;
import oracle.eclipse.tools.webservices.ant.ArtifactGenerationFailedException;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ant.GeneratedAntScriptFailedException;
import oracle.eclipse.tools.webservices.ant.IGeneratedFilesValidator;
import oracle.eclipse.tools.webservices.ant.JarClasspathBuilder;
import oracle.eclipse.tools.webservices.ant.UnexpectedFileStateException;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class WlsAntScript<T extends CommonWebServiceAntTaskArguments>
extends WorkspaceModifyOperation {
    private final T arguments;
    private final File antScript;
    private final File antLogFile;
    private final String templateId;
    private IGeneratedFilesValidator validator;
    private static final String BUILD_LOG = "ant/build_log.txt";
    private static final String DEFAULT_BUILD_FILE = "ant/build.xml";
    private static final String ANT_CLASS_PATH_NAME = "ant/oepeWlsAntCP";
    private static final String JAR_EXT = ".jar";

    protected WlsAntScript(T arguments, String templateId) {
        super((ISchedulingRule)((CommonWebServiceAntTaskArguments)arguments).getProject().getWorkspace().getRoot());
        this.arguments = arguments;
        this.templateId = templateId;
        File projectWorkingDir = WebServicesCorePlugin.getDefault().getStateLocation().toFile();
        this.antLogFile = new File(projectWorkingDir, BUILD_LOG);
        if (((CommonWebServiceAntTaskArguments)arguments).getAntScript() == null) {
            this.antScript = new File(projectWorkingDir, DEFAULT_BUILD_FILE);
        } else {
            URI uri = ((CommonWebServiceAntTaskArguments)arguments).getAntScript().getLocationURI();
            if (uri == null) {
                throw new NullPointerException("Unable to determine ant script location from: " + ((CommonWebServiceAntTaskArguments)arguments).getAntScript());
            }
            this.antScript = new File(uri);
        }
    }

    public void setValidator(IGeneratedFilesValidator validator) {
        this.validator = validator;
    }

    private void createDirIfNeeded(File f) throws FileNotFoundException {
        if (f.exists()) {
            return;
        }
        if (!f.mkdirs()) {
            throw new FileNotFoundException(this.antLogFile.getParent());
        }
        if (!f.canWrite()) {
            throw new FileNotFoundException(this.antLogFile.getParent());
        }
    }

    protected final void runAnt(IProgressMonitor monitor) throws GeneratedAntScriptFailedException, CoreException, IOException {
        this.createDirIfNeeded(this.antLogFile.getParentFile());
        AntRunner runner = this.createAntRunner();
        runner.addBuildLogger("org.apache.tools.ant.DefaultLogger");
        runner.setBuildFileLocation(this.antScript.toString());
        String jarFileName = "ant/oepeWlsAntCP.jar";
        JarClasspathBuilder jarCPBuilder = new JarClasspathBuilder(WebServicesCorePlugin.getDefault().getStateLocation().toFile(), jarFileName);
        File manJar = jarCPBuilder.createJar(((CommonWebServiceAntTaskArguments)this.arguments).getToolsRuntimeClasspath(), ((CommonWebServiceAntTaskArguments)this.arguments).getProject(), monitor);
        runner.setCustomClasspath(new URL[]{manJar.toURI().toURL()});
        String manfestJarPath = URLDecoder.decode(manJar.getCanonicalPath(), "UTF-8");
        String javahome = "-Djava.home=" + WebServiceProject.getJavaHome(((CommonWebServiceAntTaskArguments)this.arguments).getProject());
        String clonevm = "-Dant.build.clonevm=true";
        String forkedClassPath = "-Dfork.class.path=" + manfestJarPath;
        runner.setArguments(new String[]{clonevm, javahome, forkedClassPath, "-Dbuild.sysclasspath=last", "-logfile", this.antLogFile.getAbsolutePath()});
        try {
            runner.run(monitor);
        }
        catch (CoreException e) {
            throw new GeneratedAntScriptFailedException(this.antScript, this.antLogFile, this.getAntLogContents(), e);
        }
    }

    protected AntRunner createAntRunner() {
        return new AntRunner();
    }

    protected final void generate(IProgressMonitor monitor) throws AntScriptCreationFailedException {
        if (this.templateId == null) {
            throw new AntScriptCreationFailedException("Unable to identify ant script template");
        }
        try {
            ITemplateBean bean = this.createTemplateBean();
            String buildFileContents = TemplateService.generate((String)this.templateId, (ITemplateBean)bean);
            this.createDirIfNeeded(this.antScript.getParentFile());
            if (!this.antScript.exists() && !this.antScript.createNewFile()) {
                throw new FileNotFoundException(this.antScript.getParent());
            }
            OutputStream scriptOut = null;
            try {
                scriptOut = new BufferedOutputStream(new FileOutputStream(this.antScript));
                scriptOut.write(buildFileContents.getBytes("UTF-8"));
            }
            finally {
                if (scriptOut != null) {
                    scriptOut.close();
                }
                monitor.done();
            }
        }
        catch (IOException e) {
            throw new AntScriptCreationFailedException(e);
        }
        catch (GenerationFailedException e) {
            throw new AntScriptCreationFailedException((Exception)((Object)e));
        }
    }

    protected abstract ITemplateBean createTemplateBean();

    protected abstract IResource[] refreshList();

    private void refreshResources(IResource[] refreshList, IProgressMonitor monitor) throws CoreException {
        IResource[] iResourceArray = refreshList;
        int n = refreshList.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource != null) {
                resource.refreshLocal(2, monitor);
            }
            ++n2;
        }
    }

    protected final void refresh(IProgressMonitor monitor) {
        IResource[] resourceRefreshList = this.refreshList();
        if (resourceRefreshList == null) {
            resourceRefreshList = new IResource[]{};
        }
        try {
            this.refreshResources(resourceRefreshList, monitor);
            if (((CommonWebServiceAntTaskArguments)this.arguments).getAntScript() != null) {
                ((CommonWebServiceAntTaskArguments)this.arguments).getAntScript().refreshLocal(2, monitor);
            }
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)ce, (String)"Could not refresh workspace");
        }
        if (((CommonWebServiceAntTaskArguments)this.arguments).getAntScript() != null && !((CommonWebServiceAntTaskArguments)this.arguments).getAntScript().exists()) {
            throw new ArtifactGenerationFailedException((IResource)((CommonWebServiceAntTaskArguments)this.arguments).getAntScript());
        }
        if (((CommonWebServiceAntTaskArguments)this.arguments).getExecuteAnt()) {
            IResource[] iResourceArray = resourceRefreshList;
            int n = resourceRefreshList.length;
            int n2 = 0;
            while (n2 < n) {
                IResource file = iResourceArray[n2];
                if (file != null && !file.exists()) {
                    throw new ArtifactGenerationFailedException(file);
                }
                ++n2;
            }
        }
    }

    public final void execute(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)4);
        try {
            if (this.validateFileState((IProgressMonitor)monitor.newChild(1))) {
                this.generate((IProgressMonitor)monitor.newChild(1));
                if (((CommonWebServiceAntTaskArguments)this.arguments).getExecuteAnt()) {
                    this.runAnt((IProgressMonitor)monitor.newChild(1));
                }
                this.refresh((IProgressMonitor)monitor.newChild(1));
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private void addIfExists(IResource file, List<IResource> readonly, List<IFile> overwrite) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            IContainer parent;
            IContainer iContainer = parent = file.getType() == 1 ? file.getParent() : (IContainer)file;
            if (!parent.exists()) {
                try {
                    FolderUtil.createFolder((IProject)((CommonWebServiceAntTaskArguments)this.arguments).getProject(), (String)parent.getProjectRelativePath().toPortableString());
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (CoreException)e);
                    throw new RuntimeException(e);
                }
            } else if (this.isReadOnly((IResource)parent)) {
                readonly.add((IResource)parent);
            }
        } else if (file.getType() == 1) {
            if (this.isReadOnly(file)) {
                readonly.add(file);
            } else {
                overwrite.add((IFile)file);
            }
            IContainer parent = file.getParent();
            if (this.isReadOnly((IResource)parent)) {
                readonly.add((IResource)parent);
            }
        }
    }

    private boolean isReadOnly(IResource rsrc) {
        ResourceAttributes attrs = rsrc.getResourceAttributes();
        return attrs == null ? true : attrs.isReadOnly();
    }

    protected boolean validateFileState(IProgressMonitor monitor) throws UnexpectedFileStateException {
        IResource[] resourceRefreshList = this.refreshList();
        if (resourceRefreshList == null || resourceRefreshList.length == 0) {
            return true;
        }
        try {
            this.refreshResources(resourceRefreshList, monitor);
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)ce, (String)"Could not refresh workspace");
        }
        ArrayList<IResource> toValidate = new ArrayList<IResource>(resourceRefreshList.length);
        ArrayList<IFile> toOverwrite = new ArrayList<IFile>(resourceRefreshList.length);
        this.addIfExists((IResource)((CommonWebServiceAntTaskArguments)this.arguments).getAntScript(), toValidate, toOverwrite);
        if (((CommonWebServiceAntTaskArguments)this.arguments).getExecuteAnt()) {
            IResource[] iResourceArray = resourceRefreshList;
            int n = resourceRefreshList.length;
            int n2 = 0;
            while (n2 < n) {
                IResource rsrc = iResourceArray[n2];
                this.addIfExists(rsrc, toValidate, toOverwrite);
                ++n2;
            }
        }
        return this.validator == null || this.validator.validateFiles(monitor, toOverwrite, toValidate);
    }

    public final String getAntLogContents() {
        if (!((CommonWebServiceAntTaskArguments)this.arguments).getExecuteAnt()) {
            return "<ant not run>";
        }
        if (!this.antLogFile.exists()) {
            return "<no log file>";
        }
        StringBuilder builder = new StringBuilder();
        try {
            String line = null;
            try (BufferedReader reader = null;){
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.antLogFile), StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    builder.append(line).append('\n');
                }
            }
            return builder.toString();
        }
        catch (IOException e) {
            return "<" + e.getLocalizedMessage() + "   while parsing log file>";
        }
    }

    public T getArguments() {
        return this.arguments;
    }
}

