/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ant;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Manifest;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.fileio.ManifestUtil;
import oracle.eclipse.tools.common.util.fileio.ZipUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public class JarClasspathBuilder {
    private final File workingDir;
    private final String baseFileName;

    public JarClasspathBuilder(File workingDir, String baseFileName) {
        this.workingDir = workingDir;
        this.baseFileName = baseFileName;
    }

    public File createJar(URL[] urls, IProject project, IProgressMonitor monitor) throws IOException {
        monitor.beginTask("Creating Class Path Entries", 1000);
        try {
            File classpathJarFile = new File(this.workingDir, this.baseFileName);
            try {
                FileUtil.delete((File)classpathJarFile);
            }
            catch (IOException iOException) {
                if (classpathJarFile != null && classpathJarFile.exists()) {
                    File file = classpathJarFile;
                    monitor.done();
                    return file;
                }
                monitor.done();
                return null;
            }
            Manifest systemClasspathContributionsJarManifest = new Manifest();
            String classPath = this.convertToManifestClasspath(urls, project);
            systemClasspathContributionsJarManifest.getMainAttributes().putValue("Class-Path", classPath);
            byte[] classpathContributionsJarManifestContent = ManifestUtil.toByteArray((Manifest)systemClasspathContributionsJarManifest);
            File classpathContributionsJarStagingFolder = new File(String.valueOf(classpathJarFile.getAbsolutePath()) + ".temp");
            File classpathContributionsJarStagingFile = new File(classpathContributionsJarStagingFolder, "META-INF/MANIFEST.MF");
            FileUtil.delete((File)classpathContributionsJarStagingFolder);
            FileUtil.writeFile((File)classpathContributionsJarStagingFile, (byte[])classpathContributionsJarManifestContent);
            ZipUtil.zip((File)classpathContributionsJarStagingFolder, (File)classpathJarFile);
            FileUtil.delete((File)classpathContributionsJarStagingFolder);
            monitor.worked(200);
            File file = classpathJarFile;
            return file;
        }
        finally {
            monitor.done();
        }
    }

    private String convertToManifestClasspath(URL[] urls, IProject project) {
        StringBuilder builder = new StringBuilder();
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            builder.append(url.toString());
            builder.append(" ");
            ++n2;
        }
        return builder.toString().trim();
    }
}

