/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import oracle.eclipse.tools.common.content.TopLevelAnnotationContentDescriber;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.webservices.JAXVersion;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;

public final class WebServiceProject {
    private static final String WEB_SERVICE_CONTENT_TYPE_ID = "oracle.eclipse.tools.webservices.webServiceSource";
    private static final String WEB_SERVICE_PROVIDER_CONTENT_TYPE_ID = "oracle.eclipse.tools.webservices.webServiceProviderSource";
    private static final String WEB_SERVICE_POLICY = "Policy";
    private static final String WEB_SERVICE_POLICIES = "Policies";
    private static final String JWS_WEBOUTPUT_FOLDER_NAME = "weboutput";
    private static final String WSDL_FOLDER_NAME = "wsdls";
    private static final String POLICIES_FOLDER_NAME = "policies";
    public static final String OUTPUT = "build/jws";
    private static final String WEBCONTENT_WEBINF = "WebContent/WEB-INF";
    private static final String SRC = ".src";
    private static final String LIB = "lib";
    private static final String CLASSES = "classes";
    private IJavaProject javaProject;

    public static boolean isWebServiceProject(IProject project) {
        return JAXVersion.hasAnnotatedWebServiceFeature(project);
    }

    public WebServiceProject(IProject project) {
        this(JavaCore.create((IProject)project));
    }

    public WebServiceProject(IJavaProject javaProject) {
        if (javaProject == null) {
            throw new NullPointerException(Messages.web_service_project_must_be_a_java_project);
        }
        this.javaProject = javaProject;
    }

    public String getProjectName() {
        return this.javaProject.getProject().getName();
    }

    public IProject getProject() {
        return this.javaProject.getProject();
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IFile getWebFile() {
        return this.getInputWebInf().getFile("web.xml");
    }

    public IFile getWeblogicFile() {
        return this.getInputWebInf().getFile("weblogic.xml");
    }

    public String getContextRoot() {
        WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.getProject());
        return webArtifactEdit.getServerContextRoot();
    }

    public IFolder getInputWebInf() {
        return this.javaProject.getProject().getFolder(WEBCONTENT_WEBINF);
    }

    public IFolder getInputWebInfLibFolder() {
        return this.getInputWebInf().getFolder(LIB);
    }

    public IFolder getInputPoliciesFolder() {
        return this.getInputWebInf().getFolder(POLICIES_FOLDER_NAME);
    }

    public IPath getOutputFolder() {
        IPath projStateLoc = ResourcesPlugin.getPlugin().getStateLocation().append(this.javaProject.getProject().getName());
        String ret = String.valueOf(projStateLoc.toPortableString()) + File.separator + OUTPUT;
        return new Path(ret);
    }

    public IPath getOutputWebRootFolder() {
        return this.getOutputFolder().append(JWS_WEBOUTPUT_FOLDER_NAME);
    }

    public IPath getOutputWsdlFolder() {
        return this.getOutputWebRootFolder().append(WSDL_FOLDER_NAME);
    }

    public IPath getOutputPoliciesFolder() {
        return this.getOutputWebInfFolder().append(POLICIES_FOLDER_NAME);
    }

    public IPath getOutputWebInfFolder() {
        return this.getOutputWebRootFolder().append("WEB-INF");
    }

    public IPath getOutputWebInfClassesFolder() {
        return this.getOutputWebInfFolder().append(CLASSES);
    }

    public IPath ensureEmptyOutputWebInfFolder(IProgressMonitor monitor) throws CoreException {
        IPath outputFolder = this.getOutputWebInfFolder();
        try {
            FileUtil.delete((File)new File(outputFolder.toOSString()));
        }
        catch (IOException e) {
            IStatus status = WebServicesCorePlugin.createStatus(null, e);
            throw new CoreException(status);
        }
        if (!outputFolder.toFile().mkdirs()) {
            LoggingService.logDebug((Plugin)WebServicesCorePlugin.getDefault(), (String)Messages.unableToCreateDirs);
        }
        return outputFolder;
    }

    public void cleanOutputFolder(IProgressMonitor monitor) throws CoreException {
        File jwsOutputFolder = new File(this.getOutputFolder().toOSString());
        try {
            FileUtil.delete((File)jwsOutputFolder, (boolean)true);
        }
        catch (IOException e) {
            IStatus status = WebServicesCorePlugin.createStatus(null, e);
            throw new CoreException(status);
        }
    }

    public IPath getBuildJwsClassesFolder() {
        return this.getOutputFolder().append(CLASSES);
    }

    public IPath getOutputSourceFolder() {
        return this.getOutputFolder().append(SRC);
    }

    public File ensureEmptyOutputSourceFolder(IProgressMonitor monitor) throws CoreException {
        File outputSourceFolder = new File(this.getOutputSourceFolder().toOSString());
        try {
            FileUtil.delete((File)outputSourceFolder, (boolean)true);
        }
        catch (IOException e) {
            IStatus status = WebServicesCorePlugin.createStatus(null, e);
            throw new CoreException(status);
        }
        return outputSourceFolder;
    }

    public IPath ensureOutputSourceFolder(IProgressMonitor monitor) throws CoreException {
        IPath outputSourceFolder = this.getOutputSourceFolder();
        if (!outputSourceFolder.toFile().mkdirs()) {
            LoggingService.logDebug((Plugin)WebServicesCorePlugin.getDefault(), (String)Messages.unableToCreateDirs);
        }
        return outputSourceFolder;
    }

    public String getProjectRelativeOutputWebRootFolder() {
        return "build/jws/weboutput";
    }

    public String getProjectRelativeGeneratedSourceFolder() {
        return "build/jws/.src";
    }

    public static boolean isWebService(ICompilationUnit unit, boolean acceptInterfaces) {
        block4: {
            IType[] itypes;
            block5: {
                if (unit == null) {
                    return false;
                }
                boolean wsContent = WebServiceProject.isWebService((IFile)unit.getCorrespondingResource());
                if (!wsContent) break block4;
                itypes = unit.getTypes();
                if (itypes != null && itypes.length != 0) break block5;
                return false;
            }
            try {
                return acceptInterfaces || !itypes[0].isInterface();
            }
            catch (JavaModelException e) {
                LoggingService.logDebug((Plugin)WebServicesCorePlugin.getDefault(), (String)e.getLocalizedMessage());
            }
        }
        return false;
    }

    public static boolean isWebService(IFile file) {
        block4: {
            if (file == null || !file.exists()) {
                return false;
            }
            try {
                IContentType contentType;
                IContentDescription contentDesc = file.getContentDescription();
                if (contentDesc != null && (contentType = contentDesc.getContentType()) != null) {
                    return contentType.getId().equals(WEB_SERVICE_CONTENT_TYPE_ID);
                }
            }
            catch (CoreException e) {
                if (e.getStatus().getClass().equals(FileNotFoundException.class)) break block4;
                LoggingService.logDebug((Plugin)WebServicesCorePlugin.getDefault(), (String)e.getLocalizedMessage());
            }
        }
        return false;
    }

    public static boolean isWebServiceProvider(ICompilationUnit unit, boolean acceptInterfaces) {
        block4: {
            IType[] itypes;
            block5: {
                if (unit == null) {
                    return false;
                }
                boolean wsContent = WebServiceProject.isWebServiceProvider((IFile)unit.getCorrespondingResource());
                if (!wsContent) break block4;
                itypes = unit.getTypes();
                if (itypes != null && itypes.length != 0) break block5;
                return false;
            }
            try {
                return acceptInterfaces || !itypes[0].isInterface();
            }
            catch (JavaModelException e) {
                LoggingService.logDebug((Plugin)WebServicesCorePlugin.getDefault(), (String)e.getLocalizedMessage());
            }
        }
        return false;
    }

    public static boolean isWebServiceProvider(IFile file) {
        block4: {
            if (file == null || !file.exists()) {
                return false;
            }
            try {
                IContentType contentType;
                IContentDescription contentDesc = file.getContentDescription();
                if (contentDesc != null && (contentType = contentDesc.getContentType()) != null) {
                    return contentType.getId().equals(WEB_SERVICE_PROVIDER_CONTENT_TYPE_ID);
                }
            }
            catch (CoreException e) {
                if (e.getStatus().getClass().equals(FileNotFoundException.class)) break block4;
                LoggingService.logDebug((Plugin)WebServicesCorePlugin.getDefault(), (String)e.getLocalizedMessage());
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPolicyEnabled(ICompilationUnit unit) {
        if (unit == null) {
            return false;
        }
        try {
            IType[] itypes = unit.getTypes();
            if (itypes == null) return false;
            if (itypes.length == 0) {
                return false;
            }
            IAnnotation[] annotations = itypes[0].getAnnotations();
            if (annotations == null) return false;
            if (annotations.length == 0) {
                return false;
            }
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotation.getElementName() != null) {
                    if (annotation.getElementName().contains(WEB_SERVICE_POLICY)) return true;
                    if (annotation.getElementName().contains(WEB_SERVICE_POLICIES)) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logDebug((Plugin)WebServicesCorePlugin.getDefault(), (String)e.getLocalizedMessage());
        }
        return false;
    }

    public Collection<ICompilationUnit> findWebServices() {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>();
        try {
            IPackageFragment[] pkgs;
            IPackageFragment[] iPackageFragmentArray = pkgs = this.javaProject.getPackageFragments();
            int n = pkgs.length;
            int n2 = 0;
            while (n2 < n) {
                IResource pkgResource;
                IPackageFragment pkg = iPackageFragmentArray[n2];
                if (pkg.exists() && (pkgResource = pkg.getCorrespondingResource()) != null) {
                    ICompilationUnit[] units;
                    ICompilationUnit[] iCompilationUnitArray = units = pkg.getCompilationUnits();
                    int n3 = units.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICompilationUnit unit = iCompilationUnitArray[n4];
                        if (WebServiceProject.isWebService(unit, false)) {
                            result.add(unit);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LoggingService.traceException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e);
        }
        return result;
    }

    public static Collection<IFile> getFilesWithExtension(IContainer container, String extension) throws CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        WebServiceProject.addFilesWithExtension(files, container, extension);
        return files;
    }

    public static void addFilesWithExtension(Collection<IFile> result, IContainer container, String extension) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IFile) {
                IFile file = (IFile)member;
                String thisExtension = file.getFileExtension();
                if (thisExtension != null && thisExtension.equals(extension)) {
                    result.add(file);
                }
            } else if (member instanceof IFolder) {
                WebServiceProject.addFilesWithExtension(result, (IContainer)((IFolder)member), extension);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasWebServiceProviderWsdlLocationAttribute(ICompilationUnit unit) {
        if (unit == null) {
            return false;
        }
        try {
            boolean wsContent = WebServiceProject.isWebServiceProvider((IFile)unit.getCorrespondingResource());
            if (!wsContent) return false;
            try {
                Object valPairProperty;
                IContentDescription contentDesc = ((IFile)unit.getCorrespondingResource()).getContentDescription();
                if (contentDesc == null || !((valPairProperty = contentDesc.getProperty(TopLevelAnnotationContentDescriber.ELEMENT_VALUE_PAIRS_PROPERTY)) instanceof String) || !((String)valPairProperty).contains("wsdlLocation")) return false;
                return true;
            }
            catch (CoreException e) {
                if (e.getStatus().getClass().equals(FileNotFoundException.class)) return false;
                LoggingService.logDebug((Plugin)WebServicesCorePlugin.getDefault(), (String)e.getLocalizedMessage());
            }
            return false;
        }
        catch (JavaModelException e) {
            LoggingService.logDebug((Plugin)WebServicesCorePlugin.getDefault(), (String)e.getLocalizedMessage());
        }
        return false;
    }

    public static String getJavaHome(IProject project) {
        try {
            return WebServiceProject.getJavaHomeFile(project).getCanonicalPath();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static File getJavaHomeFile(IProject project) {
        try {
            IProject projectToGetVMFrom = null;
            if (WtpProjectUtil.isEarProject((IProject)project)) {
                Set projectsReferencedByEar = WtpProjectUtil.findProjectsReferencedByEar((IProject)project);
                for (IProject childProject : projectsReferencedByEar) {
                    if (childProject == project || WtpProjectUtil.isEarProject((IProject)childProject)) continue;
                    projectToGetVMFrom = childProject;
                    IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)JavaCore.create((IProject)projectToGetVMFrom));
                    return vmInstall.getInstallLocation();
                }
            } else {
                projectToGetVMFrom = project;
            }
            if (projectToGetVMFrom == null) {
                throw new RuntimeException(Messages.no_project_vm_ant_exception);
            }
            return JavaRuntime.getVMInstall((IJavaProject)JavaCore.create((IProject)projectToGetVMFrom)).getInstallLocation();
        }
        catch (CoreException e2) {
            throw new RuntimeException(e2);
        }
    }
}

