/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public enum JAXVersion {
    JAX_WS("2.1");

    private final String version;
    public static final IProjectFacet ORACLE_WEBLOGIC_WEB_SERVICE_FEATURE;
    public static final IProjectFacet ORACLE_WEBLOGIC_WEB_SERVICE_CLIENT_FEATURE;

    static {
        ORACLE_WEBLOGIC_WEB_SERVICE_FEATURE = ProjectFacetsManager.getProjectFacet((String)"oracle.weblogic.webservices");
        ORACLE_WEBLOGIC_WEB_SERVICE_CLIENT_FEATURE = ProjectFacetsManager.getProjectFacet((String)"oracle.weblogic.webservice.clients");
    }

    public static boolean hasAnnotatedWebServiceFeature(IProject project) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)ORACLE_WEBLOGIC_WEB_SERVICE_FEATURE.getId());
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)e);
            return false;
        }
    }

    public static boolean hasWebServiceClientFeature(IProject project) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)ORACLE_WEBLOGIC_WEB_SERVICE_CLIENT_FEATURE.getId());
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)e);
            return false;
        }
    }

    private JAXVersion(String version) {
        this.version = version;
    }

    public boolean isOnResource(IResource rsrc) {
        return rsrc != null ? this.isOnProject(rsrc.getProject()) : false;
    }

    public boolean isOnProject(IProject project) {
        if (project == null) {
            return false;
        }
        if (ORACLE_WEBLOGIC_WEB_SERVICE_FEATURE == null || ORACLE_WEBLOGIC_WEB_SERVICE_CLIENT_FEATURE == null) {
            LoggingService.logFatal((String)"oracle.eclipse.tools.webservices", (String)Messages.facet_error_loading);
        }
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null) {
                if (facetedProject.hasProjectFacet(ORACLE_WEBLOGIC_WEB_SERVICE_FEATURE)) {
                    IProjectFacetVersion projectFacetVersion = facetedProject.getInstalledVersion(ORACLE_WEBLOGIC_WEB_SERVICE_FEATURE);
                    return this == JAXVersion.fromProjectFacetVersion(projectFacetVersion);
                }
                if (facetedProject.hasProjectFacet(ORACLE_WEBLOGIC_WEB_SERVICE_CLIENT_FEATURE)) {
                    IProjectFacetVersion projectFacetVersion = facetedProject.getInstalledVersion(ORACLE_WEBLOGIC_WEB_SERVICE_CLIENT_FEATURE);
                    return this == JAXVersion.fromProjectFacetVersion(projectFacetVersion);
                }
            }
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)e);
        }
        return false;
    }

    public static final JAXVersion fromString(String version) {
        JAXVersion[] jAXVersionArray = JAXVersion.values();
        int n = jAXVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            JAXVersion jaxInstance = jAXVersionArray[n2];
            if (jaxInstance.version.equals(version)) {
                return jaxInstance;
            }
            ++n2;
        }
        throw new IllegalArgumentException(Messages.bind((String)Messages.unknown_jaxversion, (Object)version));
    }

    public static final JAXVersion fromProjectFacetVersion(IProjectFacetVersion version) {
        return JAXVersion.fromString(version.getVersionString());
    }

    public String toString() {
        return this.version;
    }
}

