/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.whitelist.internal;

import java.util.Set;
import java.util.TreeSet;
import oracle.eclipse.tools.cloud.server.internal.WhitelistScanToolRunner;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.LoginConfig;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.sapphire.modeling.ResourceStoreException;

public class DeploymentDescriptorProblemQuickFixer {
    public static final String MISSING_UNIQUE_COOKIE_PATH = "<cookie-path>";
    public static final String MISSING_LOGIN_CONFIG = "<login-config>";
    public static final String MISSING_VERBOSE = "<verbose>";
    public static final String MISSING_SESSION_DESC = "<session-descriptor>";
    private static Set<String> problemDescription = new TreeSet<String>();

    static {
        problemDescription.add(MISSING_UNIQUE_COOKIE_PATH);
        problemDescription.add(MISSING_VERBOSE);
        problemDescription.add(MISSING_LOGIN_CONFIG);
        problemDescription.add(MISSING_SESSION_DESC);
    }

    public static void addUniqueCookiePath(IProject proj) throws ResourceStoreException {
        IWebLogicWebModuleDescriptor descriptor = WebLogicDescriptorFactory.getWebDescriptor((IProject)proj);
        if (descriptor != null && descriptor.getSessionConfiguration() != null) {
            descriptor.getSessionConfiguration().setCookiePath("/" + proj.getName());
            descriptor.resource().save();
            descriptor.dispose();
        }
    }

    public static void addVerbose(IProject proj) throws ResourceStoreException {
        IWebLogicWebModuleDescriptor descriptor = WebLogicDescriptorFactory.getWebDescriptor((IProject)proj);
        if (descriptor != null && descriptor.getSessionConfiguration() != null) {
            descriptor.getJspDescriptorSection().setVerbose(Boolean.valueOf(false));
            descriptor.resource().save();
            descriptor.dispose();
        }
    }

    public static void addLoginConfig(IProject proj) {
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)proj);
        if (provider == null) {
            return;
        }
        provider.modify(new Runnable(){

            @Override
            public void run() {
                Object mObj = provider.getModelObject();
                if (mObj instanceof WebApp) {
                    WebApp webApp = (WebApp)mObj;
                    LoginConfig loginCfg = WebFactory.eINSTANCE.createLoginConfig();
                    webApp.getLoginConfigs().add(loginCfg);
                }
            }
        }, (IPath)new Path("WEB-INF/web.xml"));
    }

    public static String findMissingTag(IMarker marker) throws CoreException {
        String msg = marker.getAttribute("message").toString();
        if (msg.startsWith(WhitelistScanToolRunner.Resources.errorFoundOnProj)) {
            return null;
        }
        for (String s : problemDescription) {
            if (msg.indexOf(s) <= 0) continue;
            return s;
        }
        return null;
    }

    public static void fix(IMarker marker) throws CoreException, ResourceStoreException {
        IProject proj = marker.getResource().getProject();
        String msg = marker.getAttribute("message").toString();
        if (msg.contains(MISSING_LOGIN_CONFIG)) {
            DeploymentDescriptorProblemQuickFixer.addLoginConfig(proj);
        } else if (msg.contains(MISSING_UNIQUE_COOKIE_PATH) || msg.contains(MISSING_SESSION_DESC)) {
            DeploymentDescriptorProblemQuickFixer.addUniqueCookiePath(proj);
        } else if (msg.contains(MISSING_VERBOSE)) {
            DeploymentDescriptorProblemQuickFixer.addVerbose(proj);
        }
    }
}

