/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.whitelist;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.cloud.server.internal.CheckResult;
import oracle.eclipse.tools.whitelist.IReporter;
import oracle.eclipse.tools.whitelist.JavaSourceVisitor;
import oracle.eclipse.tools.whitelist.WhitelistBuilder;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;

public class WhitelistCompilationParticipant
extends CompilationParticipant
implements IReporter {
    private List<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();

    @Override
    public void reportFieldAccessProblem(IFile file, ASTNode node, IVariableBinding binding, String message, CheckResult.Severity severity) {
    }

    @Override
    public void reportMethodAccessProblem(IFile file, ASTNode node, IMethodBinding binding, String message, CheckResult.Severity severity) {
        IMarker[] markers;
        CompilationUnit unit = (CompilationUnit)node.getRoot();
        int charStart = node.getStartPosition();
        int charEnd = charStart + node.getLength();
        int lineNumber = unit.getLineNumber(charStart);
        int columnNumber = unit.getColumnNumber(charStart);
        MarkerManager markerMan = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager();
        IMarker[] iMarkerArray = markers = markerMan.findMarkers((IResource)file, "oracle.eclipse.tools.cloud.whitelist.problem", false, 1);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            int n3 = m.getAttribute("lineNumber", -1);
            String msg = m.getAttribute("message", "");
            if (msg.equals(message) && n3 == lineNumber) {
                return;
            }
            ++n2;
        }
        int problemSeverity = severity == CheckResult.Severity.ERROR ? 1 : 0;
        WhitelistProblem problem = new WhitelistProblem(file.getLocation().toString().toCharArray(), message, 67108965, new String[0], problemSeverity, charStart, charEnd, lineNumber, columnNumber);
        this.problems.add((CategorizedProblem)problem);
    }

    @Override
    public void reportTypeAccessProblem(IFile file, ASTNode node, ITypeBinding binding, String message, CheckResult.Severity severity) {
        IMarker[] markers;
        CompilationUnit unit = (CompilationUnit)node.getRoot();
        int charStart = node.getStartPosition();
        int charEnd = charStart + node.getLength();
        int lineNumber = unit.getLineNumber(charStart);
        int columnNumber = unit.getColumnNumber(charStart);
        MarkerManager markerMan = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager();
        IMarker[] iMarkerArray = markers = markerMan.findMarkers((IResource)file, "oracle.eclipse.tools.cloud.whitelist.problem", false, 1);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            int n3 = m.getAttribute("lineNumber", -1);
            String msg = m.getAttribute("message", "");
            if (msg.equals(message) && n3 == lineNumber) {
                return;
            }
            ++n2;
        }
        int problemSeverity = severity == CheckResult.Severity.ERROR ? 1 : 0;
        WhitelistProblem problem = new WhitelistProblem(file.getLocation().toString().toCharArray(), message, 67108965, new String[0], problemSeverity, charStart, charEnd, lineNumber, columnNumber);
        this.problems.add((CategorizedProblem)problem);
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        super.buildStarting(files, isBatch);
    }

    public void reconcile(ReconcileContext context) {
        super.reconcile(context);
        this.problems.clear();
        try {
            CompilationUnit root = context.getAST3();
            ICompilationUnit unit = context.getWorkingCopy();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(unit.getPath());
            root.accept((ASTVisitor)new JavaSourceVisitor(file, this));
            context.putProblems("org.eclipse.jdt.core.problem", this.problems.toArray(new CategorizedProblem[this.problems.size()]));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public boolean isActive(IJavaProject project) {
        boolean ret = false;
        ret = WhitelistBuilder.isDeployToCloud(project.getProject());
        return ret;
    }

    class WhitelistProblem
    extends DefaultProblem {
        public WhitelistProblem(char[] originatingFileName, String message, int id, String[] stringArguments, int severity, int startPosition, int endPosition, int line, int column) {
            super(originatingFileName, message, id, stringArguments, severity, startPosition, endPosition, line, column);
        }

        public int getCategoryID() {
            return 0;
        }

        public String getMarkerType() {
            return "oracle.eclipse.tools.cloud.whitelist.problem";
        }
    }
}

