/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.whitelist;

import java.util.ArrayList;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.server.internal.CheckResult;
import oracle.eclipse.tools.cloud.server.internal.IWhitelistScanner;
import oracle.eclipse.tools.cloud.server.internal.NuviaqToolsFactory;
import oracle.eclipse.tools.whitelist.IReporter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;

final class JavaSourceVisitor
extends ASTVisitor {
    private final IFile file;
    private IReporter reporter;
    private IWhitelistScanner whitelistScanner;

    public JavaSourceVisitor(IFile file, IReporter reporter) {
        this.file = file;
        this.reporter = reporter;
        IProject proj = file.getProject();
        try {
            this.whitelistScanner = NuviaqToolsFactory.getInstance().createWhitelistScanner(proj);
        }
        catch (CoreException e) {
            CloudPlugin.log((Exception)((Object)e));
        }
    }

    public boolean visit(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            this.scanMethodAccess(this.file, (ASTNode)node.getName(), binding);
        }
        return true;
    }

    public boolean visit(FieldAccess node) {
        IVariableBinding binding = node.resolveFieldBinding();
        if (binding != null) {
            this.scanFieldAccess(this.file, (ASTNode)node.getName(), binding);
        }
        return true;
    }

    public boolean visit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof ITypeBinding) {
            this.scanTypeAccess(this.file, (ASTNode)node, (ITypeBinding)binding);
        } else if (binding instanceof IVariableBinding) {
            this.scanFieldAccess(this.file, (ASTNode)node.getName(), (IVariableBinding)binding);
        } else if (binding instanceof IMethodBinding) {
            IMethodBinding mb = (IMethodBinding)binding;
            this.scanMethodAccess(this.file, (ASTNode)node.getName(), mb);
        }
        return false;
    }

    public boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof ITypeBinding) {
            this.scanTypeAccess(this.file, (ASTNode)node, (ITypeBinding)binding);
        } else if (binding instanceof IVariableBinding) {
            this.scanFieldAccess(this.file, (ASTNode)node, (IVariableBinding)binding);
        }
        return false;
    }

    void scanTypeAccess(IFile file, ASTNode node, ITypeBinding binding) {
        CheckResult result;
        ITypeBinding erasure = binding.getErasure();
        String typeName = erasure.getQualifiedName();
        if (this.whitelistScanner != null && CheckResult.PASSED != (result = this.whitelistScanner.checkClassAllowed(typeName))) {
            this.reporter.reportTypeAccessProblem(file, node, erasure, result.getMessage(), result.getSeverity());
        }
    }

    void scanMethodAccess(IFile file, ASTNode node, IMethodBinding binding) {
        CheckResult result;
        ITypeBinding erasure = binding.getDeclaringClass().getErasure();
        String typeName = erasure.getQualifiedName();
        String methodName = binding.getName();
        ArrayList<String> parameterTypes = new ArrayList<String>();
        ITypeBinding[] iTypeBindingArray = binding.getParameterTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding parameterTypeBinding = iTypeBindingArray[n2];
            parameterTypes.add(parameterTypeBinding.getErasure().getQualifiedName());
            ++n2;
        }
        if (this.whitelistScanner != null && CheckResult.PASSED != (result = this.whitelistScanner.checkMethodAllowed(typeName, methodName, parameterTypes))) {
            this.reporter.reportMethodAccessProblem(file, node, binding, result.getMessage(), result.getSeverity());
        }
    }

    void scanFieldAccess(IFile file, ASTNode node, IVariableBinding binding) {
        CheckResult result;
        ITypeBinding erasure = binding.getType().getErasure();
        String typeName = erasure.getQualifiedName();
        String fieldName = binding.getName();
        if (this.whitelistScanner != null && CheckResult.PASSED != (result = this.whitelistScanner.checkFieldAllowed(typeName, fieldName))) {
            this.reporter.reportFieldAccessProblem(file, node, binding, result.getMessage(), result.getSeverity());
        }
    }
}

