/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.whitelist;

import java.io.IOException;
import java.util.List;
import oracle.eclipse.tools.whitelist.JSPWhitelistScanner;
import oracle.eclipse.tools.whitelist.WhitelistBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.IJSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.jst.jsp.core.internal.modelhandler.ModelHandlerForJSP;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class JSPWhitelistValidator
extends JSPValidator {
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspvalidator"));
    private IValidator fMessageOriginator;
    private IPreferencesService fPreferencesService = Platform.getPreferencesService();
    private static final String PREFERENCE_NODE_QUALIFIER = JSPCorePlugin.getDefault().getBundle().getSymbolicName();
    private IScopeContext[] fScopes = null;
    private JSPTranslator fTranslator = null;
    private IDOMModel fXMLModel;

    public JSPWhitelistValidator() {
        this.fMessageOriginator = this;
    }

    private void adjustIndirectPosition(IMessage m, IJSPTranslation translation) {
        if (!(translation instanceof JSPTranslationExtension)) {
            return;
        }
        IDocument jspDoc = ((JSPTranslationExtension)translation).getJspDocument();
        if (!(jspDoc instanceof IStructuredDocument)) {
            return;
        }
        IStructuredDocument sDoc = (IStructuredDocument)jspDoc;
        IStructuredDocumentRegion[] regions = sDoc.getStructuredDocumentRegions(0, m.getOffset() + m.getLength());
        int i = regions.length - 1;
        while (i >= 0) {
            IStructuredDocumentRegion region = regions[i];
            if (region.getType() == "JSP_DIRECTIVE_NAME" && this.getDirectiveName((ITextRegionCollection)region).equals("include")) {
                ITextRegion fileValueRegion = this.getAttributeValueRegion((ITextRegionCollection)region, "file");
                if (fileValueRegion != null) {
                    m.setOffset(region.getStartOffset(fileValueRegion));
                    m.setLength(fileValueRegion.getTextLength());
                } else {
                    m.setOffset(region.getStartOffset());
                    m.setLength(region.getTextLength());
                }
                m.setLineNo(sDoc.getLineOfOffset(m.getOffset()) + 1);
                break;
            }
            --i;
        }
    }

    private IMessage createMessageFromProblem(IProblem problem, IFile f, IJSPTranslation translation, IStructuredDocument structuredDoc) {
        int sev = -1;
        int sourceStart = -1;
        int sourceEnd = -1;
        sourceStart = translation.getJspOffset(problem.getSourceStart());
        sourceEnd = translation.getJspOffset(problem.getSourceEnd());
        sev = problem.isError() ? 1 : (problem.isWarning() ? 2 : 4);
        if (sev == -1) {
            return null;
        }
        if (sourceStart == -1) {
            int problemID = problem.getID();
            if ((problemID & 0x20000000) != 0 && (problemID & 0x40000000) != 0 && translation instanceof JSPTranslation) {
                JSPTranslation jspTranslation = (JSPTranslation)translation;
                Position[] jspPositions = jspTranslation.getJsp2JavaMap().keySet().toArray(new Position[jspTranslation.getJsp2JavaMap().size()]);
                int i = 0;
                while (i < jspPositions.length) {
                    sourceStart = Math.max(sourceStart, jspPositions[i].getOffset());
                    ++i;
                }
                JSPValidator.LocalizedMessage m = new JSPValidator.LocalizedMessage((JSPValidator)this, sev, problem.getMessage(), (IResource)f);
                m.setOffset(sourceStart);
                m.setLength(1);
                return m;
            }
            return null;
        }
        if (sev == -1) {
            return null;
        }
        int lineNo = structuredDoc.getLineOfOffset(sourceStart) + 1;
        JSPValidator.LocalizedMessage m = new JSPValidator.LocalizedMessage((JSPValidator)this, sev, problem.getMessage(), (IResource)f);
        m.setMarkerId("oracle.eclipse.tools.cloud.whitelist.problem");
        m.setLineNo(lineNo);
        m.setOffset(sourceStart);
        m.setLength(sourceEnd >= sourceStart ? sourceEnd - sourceStart + 1 : 0);
        if (translation.isIndirect(problem.getSourceStart())) {
            this.adjustIndirectPosition((IMessage)m, translation);
        }
        return m;
    }

    int getMessageSeverity(String key) {
        int sev = this.fPreferencesService.getInt(PREFERENCE_NODE_QUALIFIER, key, 2, this.fScopes);
        switch (sev) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case -1: {
                return -1;
            }
        }
        return 2;
    }

    public IJavaProject getJavaProject() {
        IJavaProject javaProject = null;
        try {
            String baseLocation = this.fXMLModel.getBaseLocation();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(baseLocation);
            IProject project = null;
            if (filePath.segmentCount() > 0) {
                project = root.getProject(filePath.segment(0));
            }
            if (project != null) {
                javaProject = JavaCore.create(project);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return javaProject;
    }

    void performValidation(IFile f, IReporter reporter, IStructuredModel model) {
        if (model instanceof IDOMModel) {
            IDOMModel domModel = (IDOMModel)model;
            ModelHandlerForJSP.ensureTranslationAdapterFactory((IStructuredModel)domModel);
            IDOMDocument xmlDoc = domModel.getDocument();
            this.fXMLModel = xmlDoc.getModel();
            IJavaProject proj = this.getJavaProject();
            try {
                if (!WhitelistBuilder.isDeployToCloud(proj.getProject())) {
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
            this.fTranslator = new JSPTranslator();
            this.fTranslator.reset((IDOMNode)xmlDoc, (IProgressMonitor)new NullProgressMonitor());
            this.fTranslator.translate();
            String jspServlet = this.fTranslator.getTranslation().toString();
            Document fJavaDocument = new Document(jspServlet);
            JSPWhitelistScanner translation = new JSPWhitelistScanner((IDocument)xmlDoc.getStructuredDocument(), (IDocument)fJavaDocument, proj, this.fTranslator);
            if (!reporter.isCancelled()) {
                translation.setProblemCollectingActive(true);
                translation.reconcileCompilationUnit();
                List problems = translation.getProblems();
                int i = 0;
                while (i < problems.size() && !reporter.isCancelled()) {
                    IMessage m;
                    IProblem problem = (IProblem)problems.get(i);
                    if (problem != null && (m = this.createMessageFromProblem(problem, f, (IJSPTranslation)translation, domModel.getStructuredDocument())) != null && problem.getID() != 536871362) {
                        reporter.addMessage(this.fMessageOriginator, m);
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateFile(IFile f, IReporter reporter) {
        if (DEBUG) {
            Logger.log((int)1, (String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + " validating: " + f));
        }
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(f);
                if (reporter.isCancelled() || model == null || !(model instanceof IDOMModel)) return;
                reporter.removeAllMessages(this.fMessageOriginator, (Object)f);
                this.performValidation(f, reporter, model);
                return;
            }
            catch (IOException e) {
                Logger.logException((Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (CoreException e) {
                Logger.logException((Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }
}

