/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.modules;

import java.util.List;
import java.util.Map;
import oracle.cloud.paas.model.Library;
import oracle.cloud.paas.model.LibraryDeployType;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServerBehaviour;
import oracle.eclipse.tools.cloud.server.modules.CloudSharedLibrary;
import oracle.eclipse.tools.cloud.server.modules.CustomCloudSharedLibrary;
import oracle.eclipse.tools.cloud.server.modules.ReadOnlyCloudSharedLibrary;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.wst.server.core.IServer;

public final class CloudSharedLibraries
extends RemoteData<List<Object>> {
    private final OracleCloudRuntime runtime;

    public CloudSharedLibraries(OracleCloudRuntime runtime) {
        super("shared libraries.");
        this.runtime = runtime;
    }

    public IServer server() {
        return this.runtime.server();
    }

    @Override
    protected List<Object> read() throws Exception {
        ListFactory libListFactory = ListFactory.start();
        INuviaqDeployer deployer = this.runtime.getNuviaqDeployer();
        Map<String, Library> sharedLibds = deployer.listLibraries();
        IServer server = this.server();
        for (String name : sharedLibds.keySet()) {
            Library lib = sharedLibds.get(name);
            CloudSharedLibrary m = null;
            m = lib.getDeployType() == LibraryDeployType.READONLY ? new ReadOnlyCloudSharedLibrary(this, lib, server) : new CustomCloudSharedLibrary(this, lib, server);
            libListFactory.add((Object)m);
        }
        return libListFactory.result();
    }

    public OracleCloudServerBehaviour getOracleCloudServerBehaviour() {
        return (OracleCloudServerBehaviour)((Object)this.server().loadAdapter(OracleCloudServerBehaviour.class, null));
    }
}

