/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.cloud.scanning.api.config.IClassConfiguration;
import oracle.cloud.scanning.api.config.IFileConfiguration;
import oracle.cloud.scanning.api.config.IXMLFileConfiguration;
import oracle.cloud.scanning.api.config.MissingXMLNodeResult;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.XMLElementResult;
import oracle.cloud.scanning.spi.config.factory.ConfigurationFactory;
import oracle.cloudlogic.javaservice.common.clibase.util.XMLUtil;
import oracle.eclipse.tools.cloud.server.internal.CheckResult;
import oracle.eclipse.tools.cloud.server.internal.IWhitelistScanner;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WhitelistScanner
implements IWhitelistScanner {
    private OracleCloudRuntime runtime = null;
    ConfigurationFactory factory = ConfigurationFactory.getInstance();
    IClassConfiguration classConfig = this.factory.getDefaultClassConfiguration();
    IFileConfiguration fileConfig = this.factory.getDefaultFileConfiguration();

    public WhitelistScanner(OracleCloudRuntime rt) {
        this.runtime = rt;
        this.runtime.getName();
    }

    @Override
    public CheckResult checkClassAllowed(String clazz) {
        Result chk = this.classConfig.checkClassAllowed(clazz);
        if (!chk.isAllowed()) {
            CheckResult.Severity severity = chk.getSeverity() == Result.ResultSeverity.WARNING ? CheckResult.Severity.WARNING : CheckResult.Severity.ERROR;
            return new CheckResult(false, chk.getMessage(), -1, severity);
        }
        return CheckResult.PASSED;
    }

    @Override
    public CheckResult checkFieldAllowed(String clazz, String field) {
        Result chk = this.classConfig.checkFieldAllowed(clazz, field);
        if (!chk.isAllowed()) {
            CheckResult.Severity severity = chk.getSeverity() == Result.ResultSeverity.WARNING ? CheckResult.Severity.WARNING : CheckResult.Severity.ERROR;
            return new CheckResult(false, chk.getMessage(), -1, severity);
        }
        return CheckResult.PASSED;
    }

    @Override
    public CheckResult checkMethodAllowed(String clazz, String method, List<String> arguments) {
        Result chk = this.classConfig.checkMethodAllowed(clazz, method, arguments);
        if (!chk.isAllowed()) {
            CheckResult.Severity severity = chk.getSeverity() == Result.ResultSeverity.WARNING ? CheckResult.Severity.WARNING : CheckResult.Severity.ERROR;
            return new CheckResult(false, chk.getMessage(), -1, severity);
        }
        return CheckResult.PASSED;
    }

    @Override
    public CheckResult checkFilePath(String resourcePath) {
        Result chk = this.fileConfig.checkFilePath(resourcePath);
        if (!chk.isAllowed()) {
            CheckResult.Severity severity = chk.getSeverity() == Result.ResultSeverity.WARNING ? CheckResult.Severity.WARNING : CheckResult.Severity.ERROR;
            return new CheckResult(false, chk.getMessage(), -1, severity);
        }
        return CheckResult.PASSED;
    }

    @Override
    public List<CheckResult> checkXMLFileConfiguration(String resourcePath) {
        String filePath = resourcePath.replace('\\', '/');
        int n = filePath.indexOf("/META-INF/");
        if (n < 0) {
            n = filePath.indexOf("/WEB-INF/");
        }
        if (n < 0) {
            return Collections.EMPTY_LIST;
        }
        filePath = filePath.substring(n + 1);
        IXMLFileConfiguration xmlCfg = this.fileConfig.checkXMLFileConfiguration(filePath);
        ArrayList<CheckResult> list = new ArrayList<CheckResult>();
        if (xmlCfg != null) {
            try {
                Document xmlDocument = XMLUtil.getStreamAsDocumentWithLineNumbers((InputStream)new FileInputStream(new File(resourcePath)));
                this.checkElementRecursively(list, xmlDocument.getDocumentElement(), xmlCfg);
                return list;
            }
            catch (Exception exception) {
                list.add(new CheckResult(false, "XML parsing failed on " + resourcePath));
                return list;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void checkElementRecursively(List<CheckResult> list, Element e, IXMLFileConfiguration xmlCfg) {
        int n;
        XMLElementResult r = xmlCfg.checkXMLElement(e);
        String lineNumber = e.getAttribute("ATTR_LINE_NUMBER_INTERnal");
        int n2 = n = lineNumber != null ? Integer.parseInt(lineNumber) : -1;
        if (!r.isAllowed()) {
            CheckResult.Severity severity = r.getSeverity() == Result.ResultSeverity.WARNING ? CheckResult.Severity.WARNING : CheckResult.Severity.ERROR;
            list.add(new CheckResult(false, "Element <" + e.getNodeName() + "> is not allowed.\n", n, severity));
        } else if (r.isToProcessFurther()) {
            int i = 0;
            while (i < e.getAttributes().getLength()) {
                if (!e.getAttributes().item(i).getNodeName().equals("ATTR_LINE_NUMBER_INTERnal")) {
                    Result att = xmlCfg.checkAttribute(e, e.getAttributes().item(i).getNodeName());
                    if (!att.isAllowed()) {
                        CheckResult.Severity severity = att.getSeverity() == Result.ResultSeverity.WARNING ? CheckResult.Severity.WARNING : CheckResult.Severity.ERROR;
                        list.add(new CheckResult(false, "Attribute \"" + e.getNodeName() + "\" is not allowed.\n", -1, severity));
                    } else {
                        Object severity;
                        Result attVal = xmlCfg.checkAttributeValue(e, e.getAttributes().item(i).getNodeName(), e.getAttributes().item(i).getNodeValue());
                        Object object = severity = attVal.getSeverity() == Result.ResultSeverity.WARNING ? CheckResult.Severity.WARNING : CheckResult.Severity.ERROR;
                        if (!attVal.isAllowed()) {
                            list.add(new CheckResult(false, "Attribute value\"" + e.getNodeName() + "\" is not allowed.\n", -1, (CheckResult.Severity)((Object)severity)));
                        }
                    }
                }
                ++i;
            }
            Result elVal = xmlCfg.checkXMLElementValue(e, e.getTextContent());
            if (!elVal.isAllowed()) {
                CheckResult.Severity severity = elVal.getSeverity() == Result.ResultSeverity.WARNING ? CheckResult.Severity.WARNING : CheckResult.Severity.ERROR;
                list.add(new CheckResult(false, "Element value \"" + e.getTextContent() + "\" is invalid for <" + e.getNodeName() + ">.", n, severity));
            }
            List missingNodes = xmlCfg.checkMissingNodes(e);
            for (MissingXMLNodeResult mr : missingNodes) {
                String errMsg;
                CheckResult.Severity severity = mr.getSeverity() == Result.ResultSeverity.WARNING ? CheckResult.Severity.WARNING : CheckResult.Severity.ERROR;
                String msg = this.splitToLines(mr.getMessage());
                if (mr.getNodeType() == MissingXMLNodeResult.NodeType.ELEMENT) {
                    errMsg = "Missing child element <" + mr.getNodeName() + ">.\n" + msg;
                    list.add(new CheckResult(false, errMsg, n, severity));
                    continue;
                }
                errMsg = "Missing attribute '" + mr.getNodeName() + "'.\n" + msg;
                list.add(new CheckResult(false, errMsg, n, severity));
            }
            NodeList childNodes = e.getChildNodes();
            int i2 = 0;
            while (i2 < childNodes.getLength()) {
                Node node = childNodes.item(i2);
                if (node instanceof Element) {
                    Element childElm = (Element)node;
                    this.checkElementRecursively(list, childElm, xmlCfg);
                }
                ++i2;
            }
        }
    }

    private String splitToLines(String message) {
        String ret = message.replace(". ", ". \n");
        return ret;
    }
}

