/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import java.util.List;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.PublisherDelegate;

public class PreProcessPublisher
extends PublisherDelegate {
    public IStatus execute(int kind, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        TaskModel taskModel = this.getTaskModel();
        Server server = (Server)taskModel.getObject("server");
        IRuntime rt = server.getRuntime();
        OracleCloudRuntime runtime = (OracleCloudRuntime)((Object)rt.getAdapter(OracleCloudRuntime.class));
        List modules = (List)taskModel.getObject("modules");
        for (IModule[] m : modules) {
            String contextRootPrefix;
            IModule rootModule = m[0];
            J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(rootModule.getProject());
            String webContextRoot = deployable.getContextRoot();
            if (webContextRoot.indexOf(contextRootPrefix = "/" + runtime.getTenantName() + "/" + runtime.getServiceName() + "/") >= 0) continue;
            this.updateWeblogicContextRoot(rootModule, contextRootPrefix);
        }
        return Status.OK_STATUS;
    }

    private void updateWeblogicContextRoot(IModule module, String prefix) {
        String contextRoot;
        IWebLogicWebModuleDescriptor descriptor = WebLogicDescriptorFactory.getWebDescriptor((IProject)module.getProject());
        if (descriptor != null && (contextRoot = descriptor.getContextRoot().text(false)) != null) {
            try {
                try {
                    descriptor.setContextRoot(String.valueOf(prefix) + contextRoot);
                    descriptor.resource().save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    descriptor.dispose();
                }
            }
            finally {
                descriptor.dispose();
            }
        }
    }
}

