/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import oracle.cloud.paas.exception.ConnectionException;
import oracle.eclipse.tools.cloud.AuthenticationException;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.server.internal.NuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;

public class OracleCloudServerMonitor {
    static final int PING_DELAY = 15000;
    private IServer server;
    private OracleCloudServerBehaviour behaviour;
    private Thread pingThread = null;
    private boolean exit = false;
    private boolean authenticationError = false;

    public OracleCloudServerMonitor(IServer server, OracleCloudServerBehaviour behaviour) {
        this.server = server;
        this.behaviour = behaviour;
        this.startPingThread();
        final IRuntime rt = server.getRuntime();
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)new IRuntimeLifecycleListener(){

            public void runtimeRemoved(IRuntime runtime) {
                if (runtime == rt) {
                    OracleCloudServerMonitor.this.exit = true;
                }
            }

            public void runtimeChanged(IRuntime runtime) {
                IRuntime thisRt = rt;
                if (thisRt instanceof IRuntimeWorkingCopy) {
                    thisRt = ((IRuntimeWorkingCopy)thisRt).getOriginal();
                }
                if (runtime == thisRt) {
                    OracleCloudRuntime crt = (OracleCloudRuntime)((Object)runtime.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor()));
                    crt.reset();
                    String msg = Resources.runtimeChanged;
                    Server server1 = (Server)OracleCloudServerMonitor.this.server;
                    server1.setServerStatus(CloudPlugin.createWarningStatus(msg, null));
                    server1.setServerState(0);
                    OracleCloudServerMonitor.this.startPingThread();
                    OracleCloudServerMonitor.this.authenticationError = false;
                }
            }

            public void runtimeAdded(IRuntime runtime) {
            }
        });
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)new IServerLifecycleListener(){

            public void serverRemoved(IServer server1) {
                if (OracleCloudServerMonitor.this.server == server1) {
                    OracleCloudServerMonitor.this.exit = true;
                }
            }

            public void serverChanged(IServer server) {
            }

            public void serverAdded(IServer server) {
            }
        });
    }

    public void wakeupPingThread() {
        this.startPingThread();
    }

    private void startPingThread() {
        if (this.pingThread != null) {
            this.pingThread.interrupt();
            return;
        }
        ((Server)this.server).setServerState(0);
        this.pingThread = new Thread("Oracle Cloud Server Monitor:" + this.server.getName()){

            @Override
            public void run() {
                OracleCloudServerMonitor.this.ping();
                OracleCloudServerMonitor.this.pingThread = null;
            }
        };
        this.pingThread.setDaemon(true);
        this.pingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ping() {
        boolean logConnectionError = true;
        while (!this.exit) {
            try {
                IRuntime rt = this.server.getRuntime();
                if (rt == null) {
                    return;
                }
                if (this.authenticationError) {
                    Thread.sleep(15000L);
                    continue;
                }
                OracleCloudRuntime cloudRt = (OracleCloudRuntime)((Object)rt.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor()));
                IRuntime iRuntime = rt;
                synchronized (iRuntime) {
                    String adminUrl = cloudRt.getAdminUrl();
                    if (adminUrl == null || adminUrl.length() == 0 || this.exit) {
                        return;
                    }
                    this.attemptListApplication(cloudRt);
                    if (this.exit) {
                        return;
                    }
                }
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                if (logConnectionError) {
                    String msg = String.valueOf(Resources.errFailToConnectToInstance) + "." + e.getMessage();
                    CloudPlugin.logWarning(msg, e);
                    logConnectionError = false;
                }
                ((Server)this.server).setServerStatus((IStatus)new Status(0, "oracle.eclipse.tools.cloud", ""));
                ((Server)this.server).setServerState(4);
            }
        }
    }

    private void attemptListApplication(OracleCloudRuntime cloudRt) {
        NuviaqDeployer deployer = (NuviaqDeployer)cloudRt.getNuviaqDeployer();
        try {
            String msg;
            if (cloudRt.getPassword() == null || cloudRt.getPassword().length() == 0) {
                throw new AuthenticationException("Authentication failed", new Exception("Password is null."));
            }
            deployer.listApplications();
            Server server1 = (Server)this.server;
            if (server1.getServerStatus() != null && (msg = server1.getServerStatus().getMessage()).indexOf("connect") > 0) {
                server1.setServerStatus(CloudPlugin.createInfoStatus("Republish"));
            }
            if (deployer.isServiceInstanceRestarting()) {
                server1.setServerState(1);
                server1.setServerStatus(CloudPlugin.createInfoStatus("the service is restarting..."));
            } else {
                this.behaviour.setServerStarted();
                server1.setServerStatus(null);
            }
        }
        catch (AuthenticationException ae) {
            ((Server)this.server).setServerState(3);
            ((Server)this.server).setServerStatus(CloudPlugin.createErrorStatus(Resources.errFailToAuthenticate, ae));
            String msg = Resources.errFailToAuthenticate;
            ((Server)this.server).setServerState(4);
            CloudPlugin.logError(msg, (Exception)ae.getCause());
            this.authenticationError = true;
            deployer.resetConnection();
        }
        catch (CoreException ce) {
            Throwable t = ce.getCause();
            if (t instanceof ConnectionException) {
                ((Server)this.server).setServerState(3);
                ConnectionException connException = (ConnectionException)t;
                String msg = "Connection to Oracle Cloud failed. Reconnecting...";
                ((Server)this.server).setServerState(4);
                ((Server)this.server).setServerStatus(CloudPlugin.createWarningStatus(msg, (Exception)connException));
                CloudPlugin.logWarning(Resources.errFailToConnectToInstance, (Exception)connException);
            } else {
                ((Server)this.server).setServerState(3);
                ((Server)this.server).setServerStatus(ce.getStatus());
                String msg = String.valueOf(Resources.errFailToConnectToInstance) + " " + cloudRt.getServiceName();
                ((Server)this.server).setServerState(4);
                CloudPlugin.logError(msg, (Exception)((Object)ce));
            }
            deployer.resetConnection();
        }
        catch (Exception e) {
            ((Server)this.server).setServerState(3);
            String msg = String.valueOf(Resources.errFailToConnectToInstance) + " " + cloudRt.getServiceName();
            ((Server)this.server).setServerStatus(CloudPlugin.createErrorStatus(msg, e));
            ((Server)this.server).setServerState(4);
            deployer.resetConnection();
        }
    }

    public void stop() {
        this.exit = true;
    }

    private static final class Resources
    extends NLS {
        public static String errFailToConnectToInstance;
        public static String runtimeChanged;
        public static String errFailToAuthenticate;

        static {
            Resources.initializeMessages((String)OracleCloudServerMonitor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

