/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.eclipse.tools.cloud.AuthenticationException;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.ServerBusyException;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServerMonitor;
import oracle.eclipse.tools.cloud.server.internal.WhitelistScanToolRunner;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.archive.operations.JavaEEComponentExportOperation;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentExportDataModelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProject;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class OracleCloudServerBehaviour
extends ServerBehaviourDelegate {
    private static final String CLOUD_STAGE = "cloudStage";
    private INuviaqDeployer deployer = null;
    private OracleCloudServerMonitor serverMonitor = null;

    public void restart(String launchMode) throws CoreException {
        IRuntime rt = this.getServer().getRuntime();
        OracleCloudRuntime crt = (OracleCloudRuntime)((Object)rt.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor()));
        try {
            this.deployer = crt.getNuviaqDeployer();
            this.deployer.restartServiceInstance();
            if (this.serverMonitor != null) {
                this.serverMonitor.wakeupPingThread();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public void stop(boolean force) {
    }

    protected void initialize(IProgressMonitor monitor) {
        super.initialize(monitor);
        this.startServerMonitor(monitor);
    }

    public IStatus publish(int kind, IProgressMonitor monitor) {
        if (this.getServer().getServerState() != 2) {
            return CloudPlugin.createWarningStatus("Server is not started", null);
        }
        this.setServerStatus(null);
        IStatus ret = super.publish(kind, monitor);
        return ret;
    }

    public IStatus canStart(String launchMode) {
        return CloudPlugin.createErrorStatus("Start is not supported", null);
    }

    public IStatus canRestart(String mode) {
        if (this.getServer().getServerState() == 2) {
            return Status.OK_STATUS;
        }
        return CloudPlugin.createErrorStatus("Restart is not supported", null);
    }

    public IStatus canStop() {
        return CloudPlugin.createErrorStatus("Stop operation is not supported", null);
    }

    public String getStageAreaPath() {
        File tempDir = this.getTempDirectory().toFile();
        File stageDir = new File(tempDir, CLOUD_STAGE);
        if (!stageDir.exists()) {
            stageDir.mkdirs();
        }
        return stageDir.getAbsolutePath();
    }

    protected void setServerStarted() {
        this.setServerState(2);
    }

    public void connectToCloudServer(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        this.startServerMonitor(monitor);
    }

    private void startServerMonitor(IProgressMonitor monitor) {
        try {
            Server server = (Server)this.getServer();
            server.setServerStatus(null);
            this.serverMonitor = new OracleCloudServerMonitor(this.getServer(), this);
        }
        catch (Exception e) {
            CloudPlugin.logError("Error starting Oracle Cloud Monitor", e);
        }
    }

    public void dispose() {
        if (this.serverMonitor != null) {
            this.serverMonitor.stop();
            this.serverMonitor = null;
        }
        super.dispose();
    }

    public void waitForServerStart() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        monitor.done();
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        IStatus ret;
        block21: {
            String archiveFile;
            OracleCloudServer cloudServer;
            boolean isChildModuleChanged;
            IModule rootModule;
            block20: {
                block19: {
                    if (module.length <= 1) break block19;
                    if (((Server)this.getServer()).getServerPublishState() == 1) {
                        this.setModulePublishState(module, 1);
                    }
                    this.deployer = null;
                    return;
                }
                CloudPlugin.logInfo("Start publishing module " + module[0].getName());
                rootModule = module[0];
                IServer server = this.getServer();
                isChildModuleChanged = this.isChildModuleChange(server, new IModule[]{rootModule}, monitor);
                ((Server)this.getServer()).setServerStatus((IStatus)new Status(1, "oracle.eclipse.tools.cloud", Resources.publishing));
                monitor.setTaskName("Publishing module " + module[0].getName());
                cloudServer = (OracleCloudServer)((Object)this.getServer().loadAdapter(OracleCloudServer.class, monitor));
                IRuntime rt = this.getServer().getRuntime();
                OracleCloudRuntime crt = (OracleCloudRuntime)((Object)rt.loadAdapter(OracleCloudRuntime.class, monitor));
                this.deployer = crt.getNuviaqDeployer();
                ret = Status.OK_STATUS;
                if (!(rootModule instanceof DeletedModule)) break block20;
                this.deployer = null;
                return;
            }
            if (deltaKind == 1) {
                ret = this.checkModules(cloudServer, module);
                if (!ret.isOK()) {
                    throw new CoreException(ret);
                }
                archiveFile = OracleCloudServerBehaviour.exportModuleToArchive(rootModule, this.getStageAreaPath(), monitor);
                if (archiveFile != null) {
                    this.runWhiteListScan(module[0], archiveFile, monitor);
                    ret = this.deployArchive(module[0].getName(), archiveFile, monitor);
                }
            } else if (deltaKind == 3) {
                ret = this.undeployModule(module, monitor);
            } else if (kind == 4 || deltaKind == 2 || isChildModuleChanged) {
                ret = this.checkModules(cloudServer, module);
                if (!ret.isOK()) {
                    throw new CoreException(ret);
                }
                archiveFile = OracleCloudServerBehaviour.exportModuleToArchive(rootModule, this.getStageAreaPath(), ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)500));
                this.runWhiteListScan(module[0], archiveFile, monitor);
                ret = this.redeployArchive(module[0].getName(), archiveFile, monitor);
            }
            monitor.done();
            if (ret != Status.OK_STATUS) break block21;
            this.setModulePublishState(module, 1);
            this.setServerPublishState(1);
            this.setServerStatus(null);
            CloudPlugin.logInfo("Module publish finished successfully for " + module[0].getName());
            this.deployer = null;
            return;
        }
        try {
            String msg = "Module publish failed on " + module[0].getName();
            Exception ex = (Exception)ret.getException();
            if (ex instanceof ServerBusyException) {
                msg = "Oracle server instance is busy.";
            }
            CloudPlugin.logError(msg, ex);
            throw new CoreException(ret);
        }
        catch (AuthenticationException e) {
            ((Server)this.getServer()).setServerStatus(e.getStatus());
            this.deployer = null;
        }
        catch (CoreException e) {
            try {
                ((Server)this.getServer()).setServerStatus(e.getStatus());
                this.setModulePublishState(module, 0);
                this.setServerPublishState(0);
                throw e;
            }
            catch (Throwable throwable) {
                this.deployer = null;
                throw throwable;
            }
        }
        this.setServerPublishState(0);
    }

    IStatus checkModules(OracleCloudServer cloudServer, IModule[] modules) {
        OracleCloudRuntime crt = (OracleCloudRuntime)((Object)cloudServer.getServer().getRuntime().getAdapter(OracleCloudRuntime.class));
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            IStatus sts = cloudServer.canSupportModule(module);
            if (!sts.isOK()) {
                return sts;
            }
            if (!((Boolean)crt.getConfig().isIgnoreBuildError().content()).booleanValue()) {
                try {
                    IMarker[] markers = module.getProject().findMarkers(null, true, 2);
                    ArrayList<IMarker> errorMarkers = new ArrayList<IMarker>(3);
                    if (markers != null && markers.length > 0) {
                        int j = 0;
                        int mlen = markers.length;
                        while (j < mlen) {
                            IMarker marker = markers[j];
                            int seve = marker.getAttribute("severity", 0);
                            if (seve == 2) {
                                if (errorMarkers.size() >= 3) break;
                                errorMarkers.add(marker);
                            }
                            ++j;
                        }
                        if (errorMarkers.size() != 0) {
                            StringBuffer buffer = new StringBuffer();
                            int i = 0;
                            while (i < markers.length) {
                                buffer.append(markers[i].getAttribute("message", ""));
                                String resName = markers[i].getResource().getName();
                                if (resName != null && resName.length() > 0) {
                                    buffer.append(" at " + resName);
                                }
                                ++i;
                            }
                            String msg = String.format("Error(s) found in module '%s'. Publish was cancelled. See \"Problems\" view for details.", module.getName());
                            return CloudPlugin.createErrorStatus(msg, new Exception(buffer.toString()));
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private boolean isChildModuleChange(IServer server, IModule[] parentPath, IProgressMonitor monitor) {
        IModule[] cms = server.getChildModules(parentPath, monitor);
        if (cms == null) {
            return false;
        }
        IModule[] iModuleArray = cms;
        int n = cms.length;
        int n2 = 0;
        while (n2 < n) {
            IModule cm = iModuleArray[n2];
            ArrayList<IModule> pathList = new ArrayList<IModule>(Arrays.asList(parentPath));
            pathList.add(cm);
            IModule[] childPath = pathList.toArray(new IModule[pathList.size()]);
            if (server.getModulePublishState(childPath) != 1) {
                return true;
            }
            if (this.isChildModuleChange(server, childPath, monitor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void checkWhitelistMakers(IProject proj) throws CoreException {
        IMarker[] markers;
        Workspace ws = (Workspace)ResourcesPlugin.getWorkspace();
        MarkerManager mm = ws.getMarkerManager();
        IMarker[] iMarkerArray = markers = mm.findMarkers((IResource)proj, "oracle.eclipse.tools.cloud.whitelist.problem", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            int severity;
            IMarker m = iMarkerArray[n2];
            if (m.getResource() != proj && (severity = m.getAttribute("severity", 2)) == 2) {
                String msg = Resources.errorFoundOnProj;
                throw new CoreException(CloudPlugin.createErrorStatus(msg, null));
            }
            ++n2;
        }
    }

    private void runWhiteListScan(IModule module, String archiveFile, IProgressMonitor monitor) throws CoreException {
        IProject proj = module.getProject();
        this.checkWhitelistMakers(proj);
        for (IProject p : WtpProjectUtil.findReferencedProjects((IProject)proj)) {
            this.checkWhitelistMakers(p);
        }
        FacetedProject fproj = (FacetedProject)ProjectFacetsManager.create((IProject)proj);
        IRuntime rt1 = this.getServer().getRuntime();
        OracleCloudRuntime crt = (OracleCloudRuntime)((Object)rt1.loadAdapter(OracleCloudRuntime.class, monitor));
        if (crt == null || !crt.getPerformWhitelistScanPriorToPublish()) {
            return;
        }
        WeblogicServerRuntime wlsRt = null;
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime frt : fproj.getTargetedRuntimes()) {
            IRuntime rt = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)frt);
            if (!WebLogicServerUtil.isWebLogicRuntime((IRuntime)rt)) continue;
            wlsRt = (WeblogicServerRuntime)rt.loadAdapter(WeblogicServerRuntime.class, monitor);
        }
        WhitelistScanToolRunner runner = new WhitelistScanToolRunner(crt, wlsRt, module.getProject(), archiveFile);
        IStatus ret = runner.execute(monitor);
        if (ret != Status.OK_STATUS && ret.getSeverity() != 2) {
            throw new CoreException(ret);
        }
    }

    private IStatus deployArchive(String moduleName, String archivePath, IProgressMonitor monitor) throws AuthenticationException, CoreException {
        return this.deployer.deploy(moduleName, archivePath, monitor);
    }

    private IStatus redeployArchive(String moduleName, String archivePath, IProgressMonitor monitor) throws AuthenticationException, CoreException {
        return this.deployer.redeploy(moduleName, archivePath, monitor);
    }

    private IStatus undeployModule(IModule[] module, IProgressMonitor monitor) throws AuthenticationException, CoreException {
        return this.deployer.undeploy(module[0].getName(), monitor);
    }

    public void setRepublishState() {
        this.setServerPublishState(3);
        for (IModule[] m : this.getAllModules()) {
            this.setModulePublishState(m, 3);
        }
    }

    public static String exportModuleToArchive(IModule rootModule, String stageAreaPath, IProgressMonitor monitor) throws CoreException {
        String typeId = rootModule.getModuleType().getId();
        WebComponentExportDataModelProvider provider = null;
        String archiveExt = ".war";
        if (typeId.equals("jst.web")) {
            provider = new WebComponentExportDataModelProvider();
        } else if (typeId.equals("jst.ear")) {
            provider = new EARComponentExportDataModelProvider();
            archiveExt = ".ear";
        } else if (typeId.equals("jst.ejb")) {
            archiveExt = ".jar";
            provider = new EJBComponentExportDataModelProvider();
        }
        if (provider != null) {
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)provider);
            String projName = rootModule.getProject().getName();
            model.setStringProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", projName);
            String archiveFile = String.valueOf(stageAreaPath) + "\\" + rootModule.getName() + archiveExt;
            model.setStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", archiveFile);
            model.setBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", true);
            JavaEEComponentExportOperation op = (JavaEEComponentExportOperation)provider.getDefaultOperation();
            try {
                monitor.subTask(Resources.exportTaskName);
                IStatus ret = op.execute(monitor, null);
                if (ret.getCode() != 0) {
                    throw new CoreException(ret);
                }
                return archiveFile;
            }
            catch (ExecutionException e) {
                throw new CoreException(CloudPlugin.createErrorStatus(Resources.errExportWar, (Exception)((Object)e)));
            }
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String exportTaskName;
        public static String errExportWar;
        public static String publishing;
        public static String whitelistWillBeSkipped;
        public static String errorFoundOnProj;

        static {
            Resources.initializeMessages((String)OracleCloudServerBehaviour.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

