/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.IOracleCloudServerConfig;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.server.internal.AbstractWeblogicServer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;

public class OracleCloudServer
extends AbstractWeblogicServer {
    private static final String CLOUD_WLS_INSTANCE_VERSION = "10.3.6";
    private IOracleCloudServerConfig config;

    protected void initialize() {
        super.initialize();
        ConfigResource resource = new ConfigResource(this.getServerWorkingCopy());
        this.config = (IOracleCloudServerConfig)IOracleCloudServerConfig.TYPE.instantiate((Resource)resource);
    }

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        this.getServerWorkingCopy().setAttribute("auto-publish-setting", 1);
        OracleCloudRuntime rt = (OracleCloudRuntime)((Object)this.getServer().getRuntime().loadAdapter(OracleCloudRuntime.class, monitor));
        String serviceUrl = rt.getServiceURL();
        if (serviceUrl == null) {
            return;
        }
        try {
            URL url = new URL(serviceUrl);
            String host = url.getHost();
            this.getServerWorkingCopy().setHost(host);
            ServerUtil.setServerDefaultName((IServerWorkingCopy)this.getServerWorkingCopy());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public IOracleCloudServerConfig getConfig() {
        return this.config;
    }

    public ServerPort[] getServerPorts() {
        IRuntime rt = this.getServer().getRuntime();
        OracleCloudRuntime crt = (OracleCloudRuntime)((Object)rt.getAdapter(OracleCloudRuntime.class));
        String serviceUrl = crt.getServiceURL();
        try {
            URL url = new URL(serviceUrl);
            String protocol = url.getProtocol();
            int port = url.getPort();
            if (port == -1) {
                port = "http".equals(protocol) ? 80 : 443;
            }
            ServerPort serverPort = new ServerPort("CloudServicePort", "Oracle Cloud", port, protocol);
            return new ServerPort[]{serverPort};
        }
        catch (MalformedURLException malformedURLException) {
            return new ServerPort[0];
        }
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        IStatus ret;
        IStatus sts = super.canModifyModules(add, remove);
        if (sts != Status.OK_STATUS) {
            return sts;
        }
        try {
            IServerWorkingCopy wc;
            IModule[] parents;
            if (add != null && add.length > 0 && (parents = (wc = this.getServer().createWorkingCopy()).getRootModules(add[0], null)) != null) {
                boolean supported = false;
                IModule[] iModuleArray = parents;
                int n = parents.length;
                int n2 = 0;
                while (n2 < n) {
                    IModule m = iModuleArray[n2];
                    if (m == add[0]) {
                        supported = true;
                    }
                    ++n2;
                }
                if (!supported) {
                    return CloudPlugin.createErrorStatus("Cannot add child module to Cloud Server", new Exception());
                }
            }
        }
        catch (CoreException coreException) {
            return CloudPlugin.createErrorStatus("Cannot add module to Cloud Server", new Exception());
        }
        if (add != null && (ret = this.checkAdfVersion(add)) != Status.OK_STATUS) {
            return ret;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkAdfVersion(IModule[] add) {
        IModule[] iModuleArray = add;
        int n = add.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            IProject proj = m.getProject();
            IProjectFacetVersion adfEarVer = FacetedProjectUtilities.getProjectFacetVersion((IProject)proj, (String)"oracle.adf.ear");
            IProjectFacetVersion adfWebVer = FacetedProjectUtilities.getProjectFacetVersion((IProject)proj, (String)"oracle.adf.web");
            if (adfEarVer != null || adfWebVer != null) {
                IFacetedProject facetedProject = null;
                try {
                    facetedProject = ProjectFacetsManager.create((IProject)proj);
                    for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime frt : facetedProject.getTargetedRuntimes()) {
                        WebLogicServerVersion cloudWlsVersion;
                        String wlsRtVersion;
                        WebLogicServerVersion wlsVersion;
                        IRuntime rt = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)frt);
                        String wlsRtTypeId = rt.getRuntimeType().getId();
                        if (!wlsRtTypeId.startsWith("com.bea.weblogic") || (wlsVersion = WebLogicServerVersion.convert((String)(wlsRtVersion = rt.getRuntimeType().getVersion()))).compareTo((Enum)(cloudWlsVersion = WebLogicServerVersion.convert((String)CLOUD_WLS_INSTANCE_VERSION))) >= 0) continue;
                        return CloudPlugin.createErrorStatus("ADF version of the selected project is not supported by Oracle Cloud Java Service", null);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    private static final class ConfigResource
    extends Resource {
        private final IServerWorkingCopy wc;

        public ConfigResource(IServerWorkingCopy wc) {
            super(null);
            this.wc = wc;
        }

        protected PropertyBinding createBinding(Property property) {
            if (property.definition() == IOracleCloudServerConfig.PROP_NAME) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return ConfigResource.this.wc.getName();
                    }

                    public void write(String value) {
                        ConfigResource.this.wc.setName(value);
                    }
                };
            }
            throw new IllegalStateException();
        }

        public <A> A adapt(Class<A> adapterType) {
            if (adapterType == IServerWorkingCopy.class) {
                return (A)this.wc;
            }
            return (A)super.adapt(adapterType);
        }
    }
}

