/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.cloud.CloudPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.RuntimeClasspathProviderDelegate;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Bundle;

public class OracleCloudRuntimeClasspathProvider
extends RuntimeClasspathProviderDelegate {
    private static final String[] REQUIRED_BUNDLE_IDS = new String[]{"javax.servlet", "javax.servlet.jsp"};
    private static final String JAVAX_TXT_JAR = "javax.transaction_1.0.0.0_1-1.jar";

    public IClasspathEntry[] resolveClasspathContainer(IProject project, IRuntime runtime) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        int size = REQUIRED_BUNDLE_IDS.length;
        int i = 0;
        while (i < size) {
            Bundle b = Platform.getBundle((String)REQUIRED_BUNDLE_IDS[i]);
            IPath path = OracleCloudRuntimeClasspathProvider.getJarredPluginPath(b);
            if (path != null) {
                list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
            }
            ++i;
        }
        this.addJavaxTxLib(list);
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    private void addJavaxTxLib(List<IClasspathEntry> list) {
        try {
            IPath workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            File libDir = new File(String.valueOf(workspaceRoot.toPortableString()) + "/libraries");
            File javaxTxJar = new File(libDir, JAVAX_TXT_JAR);
            if (!javaxTxJar.exists()) {
                libDir.mkdirs();
                InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("oracle/eclipse/tools/cloud/server/internal/javax.transaction_1.0.0.0_1-1.jar");
                try {
                    FileOutputStream out = new FileOutputStream(javaxTxJar.getPath(), true);
                    try {
                        int count;
                        byte[] bytes = new byte[2048];
                        while ((count = in.read(bytes)) != -1) {
                            ((OutputStream)out).write(bytes, 0, count);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            list.add(JavaCore.newLibraryEntry((IPath)new Path(javaxTxJar.getAbsolutePath()), null, null));
        }
        catch (IOException e) {
            CloudPlugin.log(e);
        }
    }

    private static IPath getJarredPluginPath(Bundle bundle) {
        try {
            File file = FileLocator.getBundleFile((Bundle)bundle);
            return new Path(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

