/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import java.util.List;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.CloudModules;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.IOracleCloudTargetConfig;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.java.JavaServiceDataSources;
import oracle.eclipse.tools.cloud.java.JavaServiceFileSystem;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.NuviaqDeployer;
import oracle.eclipse.tools.cloud.server.modules.CloudSharedLibraries;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jst.server.core.IJavaRuntimeWorkingCopy;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public final class OracleCloudRuntime
extends RuntimeDelegate
implements IJavaRuntimeWorkingCopy {
    private static final String ATTR_CLOUD_SERVICE_NAME = "ATTR_CLOUD_SERVICE_NAME";
    private static final String ATTR_CLOUD_PROFILE_ID = "ATTR_CLOUD_PROFILE_ID";
    private static final String ATTR_CLOUD_SERVICE_URL = "ATTR_CLOUD_SERVICE_URL";
    private static final String ATTR_CLOUD_JAVA_LOCATION = "ATTR_CLOUD_JAVA_LOCATION";
    private static final String ATTR_CLOUD_PERFORM_WHITELIST_SCAN_PRIOR_TO_PUBLISH = "ATTR_CLOUD_PERFORM_WHITELIST_SCAN_PRIOR_TO_PUBLISH";
    private static final String ATTR_IGNORE_BUILD_ERROR = "ATTR_IGNORE_BUILD_ERROR";
    private static final String PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    private static final String PROP_VM_INSTALL_ID = "vm-install-id";
    private INuviaqDeployer nuviaqDeployer = null;
    private IOracleCloudTargetConfig config;
    private JavaServiceFileSystem files;
    private JavaServiceDataSources datasources;
    private CloudModules modules;
    private CloudSharedLibraries libraries;
    String password = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        OracleCloudRuntime oracleCloudRuntime = this;
        synchronized (oracleCloudRuntime) {
            super.initialize();
            if (this.config != null) {
                return;
            }
            RuntimeWorkingCopy rwc = (RuntimeWorkingCopy)this.getRuntimeWorkingCopy();
            if (rwc == null) {
                rwc = new RuntimeWorkingCopy((Runtime)this.getRuntime());
            }
            ConfigResource resource = new ConfigResource(rwc);
            this.config = (IOracleCloudTargetConfig)IOracleCloudTargetConfig.TYPE.instantiate((Resource)resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INuviaqDeployer getNuviaqDeployer() {
        OracleCloudRuntime oracleCloudRuntime = this;
        synchronized (oracleCloudRuntime) {
            if (this.nuviaqDeployer == null) {
                this.nuviaqDeployer = new NuviaqDeployer(this);
            }
        }
        return this.nuviaqDeployer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOracleCloudTargetConfig getConfig() {
        OracleCloudRuntime oracleCloudRuntime = this;
        synchronized (oracleCloudRuntime) {
            if (this.config == null) {
                this.initialize();
            }
            return this.config;
        }
    }

    public String getName() {
        return this.getConfig().getName().text();
    }

    public CloudConnection connection() {
        return OracleCloudTools.connection((String)this.config.getProfileId().content());
    }

    public String getTenantName() {
        CloudConnection connection = this.connection();
        if (connection == null) {
            return "";
        }
        return connection.profile().getIdentityDomain().text();
    }

    public String getServiceName() {
        return this.getConfig().getService().text();
    }

    public String getDbServiceName() {
        try {
            INuviaqDeployer deployer = this.getNuviaqDeployer();
            String dbServiceName = deployer.getAssociatedDBServiceName();
            return dbServiceName;
        }
        catch (CoreException ce) {
            CloudPlugin.log((Exception)((Object)ce));
            return null;
        }
    }

    public String getUserName() {
        CloudConnection connection = OracleCloudTools.connection((String)this.config.getProfileId().content());
        if (connection == null) {
            return "";
        }
        return connection.profile().getUser().text();
    }

    public String getPassword() {
        CloudConnection connection = OracleCloudTools.connection((String)this.config.getProfileId().content());
        if (connection == null) {
            return "";
        }
        return (String)connection.profile().getPassword().content();
    }

    public String getAdminUrl() {
        CloudConnection connection = OracleCloudTools.connection((String)this.config.getProfileId().content());
        if (connection == null) {
            return "";
        }
        return connection.profile().getAdminUrl().text();
    }

    public String getServiceURL() {
        return this.getConfig().getServiceUrl().text();
    }

    public boolean getPerformWhitelistScanPriorToPublish() {
        return (Boolean)this.getConfig().getPerformWhitelistScanPriorToPublish().content();
    }

    public boolean isUsingDefaultJRE() {
        return false;
    }

    public IVMInstall getVMInstall() {
        if (this.getJavaVmLocation() != null) {
            return WeblogicServerRuntime.getVMInstall((IRuntime)this.getRuntime(), (IPath)this.getJavaVmLocation());
        }
        List<IVMInstall> java16Vms = OracleCloudTools.getCloudJavaVms();
        if (java16Vms.size() > 0) {
            return java16Vms.get(0);
        }
        return null;
    }

    public IPath getJavaVmLocation() {
        if (this.config.getJavaLocation().content() == null) {
            return null;
        }
        return new Path(((org.eclipse.sapphire.modeling.Path)this.config.getJavaLocation().content()).toPortableString());
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK() && status.getMessage().length() > 0) {
            return status;
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "oracle.eclipse.tools.cloud", 0, "Invalid JRE", null);
        }
        return Status.OK_STATUS;
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    protected void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_ID, id);
        }
    }

    public synchronized JavaServiceFileSystem getFileSystem() {
        if (this.files == null) {
            this.files = new JavaServiceFileSystem(this);
        }
        return this.files;
    }

    public synchronized JavaServiceDataSources getDataSourceRoot() {
        if (this.datasources == null) {
            this.datasources = new JavaServiceDataSources(this);
        }
        return this.datasources;
    }

    public synchronized CloudModules getModules() {
        if (this.modules == null) {
            this.modules = new CloudModules(this);
        }
        return this.modules;
    }

    public synchronized CloudSharedLibraries getSharedLibraries() {
        if (this.libraries == null) {
            this.libraries = new CloudSharedLibraries(this);
        }
        return this.libraries;
    }

    public IServer server() {
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getRuntime().getAdapter(OracleCloudRuntime.class) == this) {
                return server;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        OracleCloudRuntime oracleCloudRuntime = this;
        synchronized (oracleCloudRuntime) {
            this.reset();
        }
    }

    public void reset() {
        if (this.files != null) {
            this.files.dispose();
            this.files = null;
        }
        if (this.datasources != null) {
            this.datasources.dispose();
            this.datasources = null;
        }
        if (this.modules != null) {
            this.modules.dispose();
            this.modules = null;
        }
        if (this.libraries != null) {
            this.libraries.dispose();
            this.libraries = null;
        }
        if (this.nuviaqDeployer != null) {
            this.nuviaqDeployer.dispose();
            this.nuviaqDeployer = null;
        }
        super.dispose();
    }

    private static final class AttributeValueBinding
    extends ValuePropertyBinding {
        private final RuntimeWorkingCopy wc;
        private final String attribute;

        public AttributeValueBinding(RuntimeWorkingCopy wc, String attribute) {
            this.wc = wc;
            this.attribute = attribute;
        }

        public String read() {
            return this.wc.getAttribute(this.attribute, "");
        }

        public void write(String value) {
            this.wc.setAttribute(this.attribute, value);
        }
    }

    public static final class ConfigResource
    extends Resource {
        private final RuntimeWorkingCopy wc;

        public ConfigResource(RuntimeWorkingCopy wc) {
            super(null);
            this.wc = wc;
        }

        public IRuntimeWorkingCopy getRuntimeWorkingCopy() {
            return this.wc;
        }

        protected PropertyBinding createBinding(Property property) {
            PropertyDef p = property.definition();
            if (p == IOracleCloudTargetConfig.PROP_NAME) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return ConfigResource.this.wc.getName();
                    }

                    public void write(String value) {
                        ConfigResource.this.wc.setName(value);
                    }
                };
            }
            if (p == IOracleCloudTargetConfig.PROP_SERVICE) {
                return new AttributeValueBinding(this.wc, OracleCloudRuntime.ATTR_CLOUD_SERVICE_NAME);
            }
            if (p == IOracleCloudTargetConfig.PROP_JAVA_LOCATION) {
                return new AttributeValueBinding(this.wc, OracleCloudRuntime.ATTR_CLOUD_JAVA_LOCATION);
            }
            if (p == IOracleCloudTargetConfig.PROP_SERVICE_URL) {
                return new AttributeValueBinding(this.wc, OracleCloudRuntime.ATTR_CLOUD_SERVICE_URL);
            }
            if (p == IOracleCloudTargetConfig.PROP_PROFILE_ID) {
                return new AttributeValueBinding(this.wc, OracleCloudRuntime.ATTR_CLOUD_PROFILE_ID);
            }
            if (p == IOracleCloudTargetConfig.PROP_PERFORM_WHITELIST_SCAN_PRIOR_TO_PUBLISH) {
                return new AttributeValueBinding(this.wc, OracleCloudRuntime.ATTR_CLOUD_PERFORM_WHITELIST_SCAN_PRIOR_TO_PUBLISH);
            }
            if (p == IOracleCloudTargetConfig.PROP_IGNORE_BUILD_ERROR) {
                return new AttributeValueBinding(this.wc, OracleCloudRuntime.ATTR_IGNORE_BUILD_ERROR);
            }
            throw new IllegalStateException("Invalid property: " + p.name());
        }

        public <A> A adapt(Class<A> adapterType) {
            if (adapterType == IRuntimeWorkingCopy.class) {
                return (A)this.wc;
            }
            return (A)super.adapt(adapterType);
        }
    }
}

