/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServer;
import oracle.eclipse.tools.weblogic.server.internal.UrlPathEncoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.server.core.Servlet;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider2;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;

public class OracleCloudLaunchableAdapterDelegate
extends LaunchableAdapterDelegate {
    private OracleCloudServer cloudServer = null;

    public Object getLaunchable(IServer server, IModuleArtifact moduleArtifact) throws CoreException {
        IRuntime runtime = server.getRuntime();
        OracleCloudRuntime cloudRuntime = (OracleCloudRuntime)((Object)runtime.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor()));
        if (cloudRuntime == null) {
            return null;
        }
        this.cloudServer = (OracleCloudServer)((Object)server.loadAdapter(OracleCloudServer.class, (IProgressMonitor)new NullProgressMonitor()));
        if (!(moduleArtifact instanceof Servlet) && !(moduleArtifact instanceof WebResource)) {
            return null;
        }
        return new HttpLaunchable((IURLProvider2)new CloudWebUrlProvider(cloudRuntime, moduleArtifact));
    }

    private URL constructUrlForModule(OracleCloudRuntime cloudRuntime, String appBasePath, IModuleArtifact moduleArtifact) {
        try {
            WebResource resource;
            String path;
            URL url = new URL(appBasePath);
            if (url.getHost().equals("localhost")) {
                url = new URL(String.valueOf(cloudRuntime.getServiceURL()) + url.getPath());
            }
            if (moduleArtifact instanceof Servlet) {
                String path2;
                String base;
                Servlet servlet = (Servlet)moduleArtifact;
                if (servlet.getAlias() != null) {
                    base = this.normalize(url.getFile());
                    path2 = this.normalize(servlet.getAlias());
                    url = new URL(url, String.valueOf(base) + path2);
                } else {
                    base = "/servlet";
                    path2 = servlet.getServletClassName();
                }
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(base) + path2);
            } else if (moduleArtifact instanceof WebResource && (path = this.normalize((resource = (WebResource)moduleArtifact).getPath().toPortableString())).length() != 0) {
                String base = this.normalize(url.getFile());
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(base) + path);
            }
            return new UrlPathEncoder(url).asURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String normalize(String path) {
        if (path == null) {
            return "";
        }
        if (path.equals("/")) {
            return "";
        }
        if (path.length() > 0 && path.endsWith("/")) {
            return path.substring(0, path.length() - 2);
        }
        if (path.length() > 0 && !path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    class CloudWebUrlProvider
    implements IURLProvider2 {
        OracleCloudRuntime cloudRuntime;
        IModuleArtifact moduleArtifact;

        public CloudWebUrlProvider(OracleCloudRuntime rt, IModuleArtifact moduleArtifact) {
            this.cloudRuntime = rt;
            this.moduleArtifact = moduleArtifact;
        }

        public URL getModuleRootURL(IModule module) {
            URL url = null;
            try {
                INuviaqDeployer deployer = this.cloudRuntime.getNuviaqDeployer();
                IModule root = this.moduleArtifact.getModule();
                IModule[] rootModules = OracleCloudLaunchableAdapterDelegate.this.cloudServer.getRootModules(this.moduleArtifact.getModule());
                if (rootModules != null && rootModules.length > 0) {
                    root = rootModules[0];
                }
                List urls = Collections.EMPTY_LIST;
                try {
                    HashMap map = deployer.describeApplication(this.cloudRuntime.getTenantName(), this.cloudRuntime.getServiceName(), root.getName());
                    urls = (List)map.get("URLs");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (urls.size() > 0) {
                    J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(this.moduleArtifact.getModule().getProject());
                    String webContextRoot = deployable.getContextRoot();
                    for (String webUrl : urls) {
                        if (!webUrl.endsWith(webContextRoot)) continue;
                        url = OracleCloudLaunchableAdapterDelegate.this.constructUrlForModule(this.cloudRuntime, webUrl, this.moduleArtifact);
                        return url;
                    }
                }
                CloudPlugin.logWarning("Unable to get application URL from Oracle Cloud server. The launch URL is constructed from web project setting.", null);
                String rootPath = this.cloudRuntime.getServiceURL();
                J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(this.moduleArtifact.getModule().getProject());
                String webContextRoot = deployable.getContextRoot();
                if (webContextRoot.charAt(0) != '/') {
                    webContextRoot = "/" + webContextRoot;
                }
                rootPath = String.valueOf(rootPath) + webContextRoot;
                url = OracleCloudLaunchableAdapterDelegate.this.constructUrlForModule(this.cloudRuntime, rootPath, this.moduleArtifact);
            }
            catch (Exception ce) {
                CloudPlugin.log(ce);
            }
            return url;
        }

        public URL getLaunchableURL() {
            return this.getModuleRootURL(null);
        }
    }
}

