/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import com.sun.jersey.api.client.ClientHandlerException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.api.Connection;
import oracle.cloud.paas.api.ConnectionFactory;
import oracle.cloud.paas.api.JobManager;
import oracle.cloud.paas.api.JobQuery;
import oracle.cloud.paas.api.JobQueryBuilder;
import oracle.cloud.paas.api.LibraryManager;
import oracle.cloud.paas.api.ServiceInstanceLogCriteria;
import oracle.cloud.paas.api.ServiceInstanceLogCriteriaFactory;
import oracle.cloud.paas.client.cli.bean.ApplicationLogRecord;
import oracle.cloud.paas.client.cli.bean.ApplicationLogRecords;
import oracle.cloud.paas.exception.ManagerException;
import oracle.cloud.paas.exception.ResourceBusyException;
import oracle.cloud.paas.model.Application;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloud.paas.model.Association;
import oracle.cloud.paas.model.DataSource;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.JobStatus;
import oracle.cloud.paas.model.Library;
import oracle.cloud.paas.model.Log;
import oracle.cloud.paas.model.Property;
import oracle.cloud.paas.model.ServiceInstance;
import oracle.cloud.paas.model.ServiceType;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.ServiceManagerFactory;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.service.ResourceManagerService;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.common.api.service.resource.KeyStoreManagerService;
import oracle.cloudlogic.javaservice.common.api.service.resource.SSLService;
import oracle.cloudlogic.javaservice.types.CertificateDescription;
import oracle.eclipse.tools.cloud.AuthenticationException;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.ServerBusyException;
import oracle.eclipse.tools.cloud.log.AppLogQueryCriteriaFactory;
import oracle.eclipse.tools.cloud.log.IAppLogQueryCriteria;
import oracle.eclipse.tools.cloud.log.IJobsLogQueryCriteria;
import oracle.eclipse.tools.cloud.log.ISeverityEnumItem;
import oracle.eclipse.tools.cloud.log.IStatusEnumItem;
import oracle.eclipse.tools.cloud.log.JobsLogQueryCriteriaFactory;
import oracle.eclipse.tools.cloud.log.LastType;
import oracle.eclipse.tools.cloud.log.Severity;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.common.util.StringInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NuviaqDeployer
implements INuviaqDeployer {
    private OracleCloudRuntime runtime = null;
    private Connection jcsConnection = null;
    private boolean isDebug = OracleCloudTools.isDebugMode();
    private ServiceInstanceLogCriteria appLogQueryCriteria = ServiceInstanceLogCriteriaFactory.createCriteria();
    private Map<String, Map<String, String>> jobLogCache = new HashMap<String, Map<String, String>>();
    public static final int RECORDS_CHUNK_SIZE = 100;

    public NuviaqDeployer() {
    }

    @Override
    public void dispose() {
        this.jobLogCache.clear();
        this.resetConnection();
    }

    public NuviaqDeployer(OracleCloudRuntime rt) {
        this.runtime = rt;
    }

    @Override
    public Map<String, String> listApplications() throws AuthenticationException, CoreException {
        HashMap<String, String> ret = new HashMap<String, String>();
        Authenticator defaultAuthenticator = OracleCloudTools.overrideDefaultAuthenticator(this.runtime.getAdminUrl(), this.runtime.getUserName(), this.runtime.getPassword());
        ApplicationManager appManager = null;
        try {
            try {
                appManager = this.createApplicationManager();
                List list = appManager.listApplications(this.runtime.getTenantName(), this.runtime.getServiceName());
                for (Application adt : list) {
                    ret.put(adt.getApplicationName(), adt.getType().toString().toLowerCase());
                }
            }
            catch (oracle.cloud.paas.exception.AuthenticationException ae) {
                throw new AuthenticationException(ae.getMessage(), (Exception)((Object)ae));
            }
        }
        finally {
            Authenticator.setDefault(defaultAuthenticator);
        }
        return ret;
    }

    @Override
    public Map<String, Library> listLibraries() throws AuthenticationException, CoreException {
        HashMap<String, Library> ret = new HashMap<String, Library>();
        LibraryManager libManager = null;
        try {
            libManager = this.createLibraryManager();
            List list = libManager.listLibraries(this.runtime.getTenantName(), this.runtime.getServiceName());
            for (Library lib : list) {
                ret.put(lib.getVersionedName(), lib);
            }
        }
        catch (oracle.cloud.paas.exception.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), (Exception)((Object)ae));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConnection() throws CoreException {
        NuviaqDeployer nuviaqDeployer = this;
        synchronized (nuviaqDeployer) {
            if (this.jcsConnection == null) {
                String userName = this.runtime.getUserName();
                this.jcsConnection = NuviaqDeployer.createConnection(this.runtime.getAdminUrl(), this.runtime.getTenantName(), userName, this.runtime.getPassword());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        NuviaqDeployer nuviaqDeployer = this;
        synchronized (nuviaqDeployer) {
            if (this.jcsConnection != null) {
                this.jcsConnection.release();
            }
            this.jcsConnection = null;
        }
    }

    public ApplicationManager createApplicationManager() throws CoreException {
        this.createConnection();
        return this.jcsConnection.getApplicationManager();
    }

    public static Connection createConnection(String adminUrl, String identityDomain, String userName, String password) throws CoreException {
        try {
            URL endpoint = new URL(adminUrl);
            Connection connection = ConnectionFactory.createConnection((URL)endpoint, (String)identityDomain, (String)userName, (String)password);
            return connection;
        }
        catch (MalformedURLException e) {
            throw new CoreException(CloudPlugin.createErrorStatus("Malformed URL", e));
        }
        catch (Exception e) {
            throw new CoreException(CloudPlugin.createErrorStatus("Error connecting to Java Cloud Service admin endpoint", e));
        }
    }

    public LibraryManager createLibraryManager() throws CoreException {
        try {
            this.createConnection();
            LibraryManager libManager = this.jcsConnection.getLibraryManager();
            return libManager;
        }
        catch (Exception e) {
            throw new CoreException(CloudPlugin.createErrorStatus("Error initialize SSL settings", e));
        }
    }

    @Override
    public String getAssociatedDBServiceName() throws CoreException {
        ApplicationManager appManager = this.createApplicationManager();
        ServiceInstance sii = appManager.describeServiceInstance(this.runtime.getTenantName(), this.runtime.getServiceName());
        for (Association asso : sii.getAssociations()) {
            if (!asso.getTargetServiceType().equals((Object)ServiceType.DATABASE)) continue;
            return asso.getTargetInstanceName();
        }
        return null;
    }

    @Override
    public IStatus pingCloudService(String adminUrl, String userName, String password, String tenantName, String serviceName) throws AuthenticationException, CoreException {
        Authenticator defaultAuthenticator = OracleCloudTools.overrideDefaultAuthenticator(adminUrl, userName, password);
        Connection conn = null;
        try {
            try {
                conn = NuviaqDeployer.createConnection(adminUrl, tenantName, userName, password);
                ApplicationManager appMge = conn.getApplicationManager();
                appMge.listApplications(tenantName, serviceName);
            }
            catch (ClientHandlerException ce) {
                ce.printStackTrace();
                String msg = "Error connecting to Cloud endpoint:" + ce.getMessage();
                msg = String.valueOf(msg) + ". Please check your proxy settings and set -Djava.net.preferIPv4Stack=true in eclipse.ini if you are running Eclipse on JRE 1.7";
                throw new CoreException(CloudPlugin.createErrorStatus(msg, (Exception)((Object)ce)));
            }
            catch (oracle.cloud.paas.exception.AuthenticationException ae) {
                throw new AuthenticationException(ae.getMessage(), (Exception)((Object)ae));
            }
            catch (Exception e) {
                throw new CoreException(CloudPlugin.createErrorStatus(e.getMessage(), e));
            }
        }
        finally {
            if (conn != null) {
                conn.release();
            }
            Authenticator.setDefault(defaultAuthenticator);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus deploy(String moduleName, String archivePath, IProgressMonitor monitor) throws AuthenticationException, CoreException {
        Map<String, String> modulesOnServer = this.listApplications();
        if (modulesOnServer.get(moduleName) != null) {
            return this.redeploy(moduleName, archivePath, monitor);
        }
        ApplicationManager appManager = this.createApplicationManager();
        try {
            monitor.subTask("Deploy " + moduleName);
            File file = new File(archivePath);
            FileInputStream fis = new FileInputStream(file);
            ApplicationType type = ApplicationType.WAR;
            if (file.getName().endsWith("ear")) {
                type = ApplicationType.EAR;
            }
            String tenantName = this.runtime.getTenantName();
            String serviceName = this.runtime.getServiceName();
            Job Job2 = appManager.deployApplication(tenantName, serviceName, moduleName, type, (InputStream)fis);
            String jobId = Job2.getJobId();
            JobStatus status = Job2.getStatus();
            String msg = "Waiting for job " + jobId;
            msg = String.valueOf(msg) + ". Check publishing status using Oracle Cloud Java Service Logs.";
            monitor.subTask(msg);
            while (!(status.equals((Object)JobStatus.FAILED) || status.equals((Object)JobStatus.COMPLETE) || status.equals((Object)JobStatus.CANCELLED))) {
                monitor.worked(20);
                Thread.sleep(1000L);
                Job2 = appManager.describeJob(jobId);
                status = Job2.getStatus();
                if (!monitor.isCanceled()) continue;
                return CloudPlugin.createErrorStatus("Deployment to Oracle Cloud canceled", null);
            }
            if (status.equals((Object)JobStatus.FAILED)) {
                String msg1 = this.fetchJobLog((JobManager)appManager, Job2);
                return CloudPlugin.createErrorStatus("Deployment to Oracle Cloud failed, please check Error Log for detail.", new Exception(msg1));
            }
            if (this.isDebug) {
                ServiceInstance serviceIns = appManager.describeServiceInstance(this.runtime.getTenantName(), this.runtime.getServiceName());
                for (Property p : serviceIns.getProperties()) {
                    System.err.println(String.valueOf(p.getName()) + "=" + p.getValue());
                }
                Application app = appManager.describeApplication(tenantName, serviceName, moduleName);
                List appUrl = app.getApplicationUrls();
                System.err.println(appUrl);
            }
        }
        catch (ResourceBusyException re) {
            ServerBusyException se = new ServerBusyException("Cloud server instance is busy", (Exception)((Object)re));
            Job activeJob = re.getActiveJob();
            String msg = "Cloud server instance is busy. ";
            msg = activeJob != null ? String.valueOf(msg) + "The active job id is " + activeJob.getJobId() + ". Please wait for the running job finishes and try later." : String.valueOf(msg) + "The service instance may have been disabled.";
            throw new CoreException(CloudPlugin.createErrorStatus(msg, se));
        }
        catch (ManagerException me) {
            return this.handleNuviaqException((JobManager)appManager, me);
        }
        catch (FileNotFoundException fe) {
            throw new CoreException(CloudPlugin.createErrorStatus("Archive file not found", fe));
        }
        catch (InterruptedException interruptedException) {}
        return Status.OK_STATUS;
    }

    @Override
    public IStatus redeploy(String moduleName, String archivePath, IProgressMonitor monitor) throws AuthenticationException, CoreException {
        Map<String, String> modulesOnServer = this.listApplications();
        if (modulesOnServer.get(moduleName) == null) {
            return this.deploy(moduleName, archivePath, monitor);
        }
        ApplicationManager appManager = this.createApplicationManager();
        monitor.subTask("Redeploy " + moduleName);
        try {
            File file = new File(archivePath);
            FileInputStream fis = new FileInputStream(file);
            String tenantName = this.runtime.getTenantName();
            String serviceName = this.runtime.getServiceName();
            Job Job2 = appManager.redeployApplication(tenantName, serviceName, moduleName, (InputStream)fis);
            String jobId = Job2.getJobId();
            String msg = "Waiting for job " + jobId;
            msg = String.valueOf(msg) + ". Check publishing status using Oracle Cloud Java Service Logs.";
            monitor.subTask(msg);
            JobStatus status = Job2.getStatus();
            while (!(status.equals((Object)JobStatus.FAILED) || status.equals((Object)JobStatus.COMPLETE) || status.equals((Object)JobStatus.CANCELLED))) {
                monitor.worked(20);
                Thread.sleep(1000L);
                Job2 = appManager.describeJob(jobId);
                status = Job2.getStatus();
                if (!monitor.isCanceled()) continue;
                return CloudPlugin.createErrorStatus("Deployment to Oracle Cloud canceled", null);
            }
            if (status.equals((Object)JobStatus.FAILED)) {
                String msg1 = this.fetchJobLog((JobManager)appManager, Job2);
                return CloudPlugin.createErrorStatus("Deployment to Oracle Cloud failed, please check Error Log for detail.", new Exception(msg1));
            }
        }
        catch (ResourceBusyException re) {
            ServerBusyException se = new ServerBusyException("Cloud server instance is busy", (Exception)((Object)re));
            Job activeJob = re.getActiveJob();
            String msg = "The active job id is " + activeJob.getJobId();
            throw new CoreException(CloudPlugin.createErrorStatus("Cloud server instance is busy. " + msg + ". Please wait for the running job finishes and try later.", se));
        }
        catch (ManagerException me) {
            return this.handleNuviaqException((JobManager)appManager, me);
        }
        catch (FileNotFoundException fe) {
            throw new CoreException(CloudPlugin.createErrorStatus("Archive file not found", fe));
        }
        catch (InterruptedException interruptedException) {}
        return Status.OK_STATUS;
    }

    private IStatus handleNuviaqException(JobManager appManager, ManagerException me) {
        String msg = me.getMessage();
        int n = msg.indexOf("describeJob(");
        if (n > 0) {
            me.printStackTrace();
            String jobId = msg.substring(n + "describeJob(".length());
            jobId = jobId.substring(0, jobId.indexOf(41));
            Job errorType = appManager.describeJob(jobId);
            String error = this.fetchJobLog(appManager, errorType);
            return CloudPlugin.createErrorStatus("Deployment to Oracle Cloud failed, please check Error Log for detail.", new Exception(error));
        }
        return CloudPlugin.createErrorStatus("Deployment to Oracle Cloud failed, please check Error Log for detail.", (Exception)((Object)me));
    }

    @Override
    public IStatus undeploy(String moduleName, IProgressMonitor monitor) throws AuthenticationException, CoreException {
        Map<String, String> modules = this.listApplications();
        if (modules.get(moduleName) == null) {
            return Status.OK_STATUS;
        }
        ApplicationManager appManager = this.createApplicationManager();
        Application adt = new Application();
        adt.setApplicationName(moduleName);
        try {
            String tenantName = this.runtime.getTenantName();
            String serviceName = this.runtime.getServiceName();
            Job Job2 = appManager.undeployApplication(tenantName, serviceName, moduleName);
            String jobId = Job2.getJobId();
            JobStatus status = Job2.getStatus();
            String msg = "Waiting for job " + jobId;
            msg = String.valueOf(msg) + ". Check publishing status using Oracle Cloud Java Service Logs.";
            monitor.subTask(msg);
            while (!(status.equals((Object)JobStatus.FAILED) || status.equals((Object)JobStatus.COMPLETE) || status.equals((Object)JobStatus.CANCELLED))) {
                monitor.worked(20);
                Thread.sleep(1000L);
                Job2 = appManager.describeJob(jobId);
                status = Job2.getStatus();
                if (!monitor.isCanceled()) continue;
                return CloudPlugin.createErrorStatus("Deployment to Oracle Cloud canceled", null);
            }
            if (status.equals((Object)JobStatus.FAILED)) {
                String msg1 = this.fetchJobLog((JobManager)appManager, Job2);
                return CloudPlugin.createErrorStatus("Undeployment to Oracle Cloud failed, please check Error Log for detail.", new Exception(msg1));
            }
        }
        catch (ResourceBusyException re) {
            ServerBusyException se = new ServerBusyException("Cloud server instance is busy", (Exception)((Object)re));
            Job activeJob = re.getActiveJob();
            String msg = "The active job id is " + activeJob.getJobId();
            throw new CoreException(CloudPlugin.createErrorStatus("Cloud server instance is busy. " + msg + ". Please wait for the running job finishes and try later.", se));
        }
        catch (ManagerException me) {
            return this.handleNuviaqException((JobManager)appManager, me);
        }
        catch (InterruptedException interruptedException) {}
        return Status.OK_STATUS;
    }

    private String fetchJobLog(JobManager appManager, Job job) {
        Map<String, String> logsMap = this.getJobLogs(appManager, job);
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<String, String> entry : logsMap.entrySet()) {
            msg.append("[");
            msg.append(entry.getKey());
            msg.append("]\n");
            msg.append(entry.getValue());
        }
        return msg.toString();
    }

    private Map<String, String> getJobLogs(JobManager appManager, Job job) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (Log log : appManager.listJobLogs(job.getJobId())) {
            try {
                StringBuilder msg = new StringBuilder();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                appManager.fetchJobLog(job.getJobId(), log.getName(), (OutputStream)bos);
                String logContent = new String(bos.toByteArray(), StandardCharsets.UTF_8);
                msg.append(logContent);
                bos.close();
                ret.put(log.getName(), msg.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public List<Map<String, String>> listJobs() throws CoreException {
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        ApplicationManager appManager = this.createApplicationManager();
        try {
            IJobsLogQueryCriteria criteria = JobsLogQueryCriteriaFactory.getInstance();
            JobQueryBuilder builder = JobQueryBuilder.createBuilder();
            builder.identityDomain(this.runtime.getTenantName());
            builder.service(this.runtime.getServiceName());
            if (criteria != null) {
                Integer limit;
                String application = (String)criteria.getApp().content();
                if (application != null) {
                    builder.application(application);
                }
                if ((limit = (Integer)criteria.getLimit().content()) != null) {
                    builder.limit(limit.intValue());
                }
                for (IStatusEnumItem item : criteria.getStatus()) {
                    builder.status(JobStatus.valueOf((String)((oracle.eclipse.tools.cloud.log.Status)((Object)item.getItem().content())).toString()));
                }
            }
            List jobs = appManager.listJobs(builder.build());
            for (Job job : jobs) {
                HashMap<String, String> jobInfo = new HashMap<String, String>();
                String id = job.getJobId().trim();
                jobInfo.put("jobId", id);
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
                Date startTime = job.getStartedOn();
                String startTimeStr = startTime != null ? df2.format(startTime) : "0000-00-00 00:00:00 PST";
                jobInfo.put("startTime", startTimeStr);
                Date endTime = job.getEndedOn();
                String endTimeStr = endTime != null ? df2.format(endTime) : "0000-00-00 00:00:00 PST";
                jobInfo.put("endTime", endTimeStr);
                long duration = endTime != null && startTime != null ? (endTime.getTime() - startTime.getTime()) / 1000L : 0L;
                jobInfo.put("duration", Long.toString(duration));
                Date lastUpdate = job.getUpdatedOn();
                String lastUpdateTimeStr = lastUpdate != null ? df2.format(lastUpdate) : "0000-00-00 00:00:00 PST";
                jobInfo.put("lastUpdateTime", lastUpdateTimeStr);
                jobInfo.put("status", job.getStatus().name());
                jobInfo.put("operation", job.getOperation());
                jobInfo.put("application", job.getApplicationName());
                ret.add(jobInfo);
            }
            Collections.sort(ret, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> o1, Map<String, String> o2) {
                    String d1 = o1.get("startTime");
                    String d2 = o1.get("startTime");
                    return d1.compareTo(d2);
                }
            });
            Collections.reverse(ret);
        }
        catch (ManagerException managerException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, String>> listApplicationLogs() throws CoreException {
        NuviaqDeployer nuviaqDeployer = this;
        synchronized (nuviaqDeployer) {
            ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
            ApplicationManager appManager = this.createApplicationManager();
            try {
                this.setAppLogFilter();
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ApplicationLogRecords.class});
                String idDomainName = this.runtime.getTenantName();
                String serviceName = this.runtime.getServiceName();
                InputStream in = appManager.queryServiceInstanceLogs(idDomainName, serviceName, this.appLogQueryCriteria);
                BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                StringBuffer sb = new StringBuffer();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
                ApplicationLogRecords records = (ApplicationLogRecords)jaxbContext.createUnmarshaller().unmarshal((InputStream)new StringInputStream(sb.toString()));
                List list = records.getMsg();
                for (ApplicationLogRecord r : list) {
                    HashMap<String, String> logInfo = new HashMap<String, String>();
                    Date timestamp = r.getDateTime();
                    SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
                    String newDateStr = df2.format(timestamp);
                    logInfo.put("timestamp", newDateStr);
                    logInfo.put("severity", r.getType());
                    StringBuffer text = new StringBuffer(r.getText());
                    logInfo.put("message", text.toString());
                    if (r.getSuppl_detail() != null) {
                        text.append("\n" + r.getSuppl_detail());
                    }
                    logInfo.put("details", text.toString());
                    logInfo.put("level", r.getLevel());
                    ret.add(logInfo);
                }
                Collections.sort(ret, new Comparator<Map<String, String>>(){

                    @Override
                    public int compare(Map<String, String> o1, Map<String, String> o2) {
                        String d1 = o1.get("timestamp");
                        String d2 = o1.get("timestamp");
                        return d1.compareTo(d2);
                    }
                });
                Collections.reverse(ret);
            }
            catch (ManagerException me) {
                CloudPlugin.log((Exception)((Object)new CoreException(CloudPlugin.createErrorStatus("Error loading Cloud service instance log", (Exception)((Object)me)))));
            }
            catch (Throwable e) {
                CloudPlugin.log((Exception)((Object)new CoreException(CloudPlugin.createErrorStatus("Error loading Cloud service instance log", (Exception)e))));
            }
            return ret;
        }
    }

    private void setAppLogFilter() {
        Integer last;
        String value;
        this.appLogQueryCriteria.clear();
        IAppLogQueryCriteria criteriaPref = AppLogQueryCriteriaFactory.getInstance(this.runtime);
        Integer limit = (Integer)criteriaPref.getLimit().content();
        if (limit != null) {
            this.appLogQueryCriteria.limit(limit.intValue());
        }
        for (ISeverityEnumItem item : criteriaPref.getSeverities()) {
            this.appLogQueryCriteria.severity(((Severity)((Object)item.getItem().content())).toString());
        }
        String appName = (String)criteriaPref.getApp().content();
        if (appName != null && appName.trim().length() > 0) {
            this.appLogQueryCriteria.application(appName);
        }
        if ((value = (String)criteriaPref.getContain().content()) != null && value.trim().length() > 0) {
            String[] vals;
            String[] stringArray = vals = value.split(",");
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.appLogQueryCriteria.contains(s);
                ++n2;
            }
        }
        if ((last = (Integer)criteriaPref.getLastValue().content()) != null) {
            int lastSize = last;
            LastType lastType = (LastType)((Object)criteriaPref.getLastType().content());
            Calendar c = Calendar.getInstance();
            Date starttime = null;
            Date endtime = new Date();
            c.setTime(endtime);
            switch (lastType) {
                case MINUTE: {
                    c.add(12, -lastSize);
                    starttime = c.getTime();
                    break;
                }
                case HOUR: {
                    c.add(10, -lastSize);
                    starttime = c.getTime();
                    break;
                }
                case DAY: {
                    c.add(5, -lastSize);
                    starttime = c.getTime();
                    break;
                }
                case MONTH: {
                    c.add(2, -lastSize);
                    starttime = c.getTime();
                    break;
                }
                case YEAR: {
                    c.add(1, -lastSize);
                    starttime = c.getTime();
                }
            }
            if (starttime != null) {
                this.appLogQueryCriteria.after(starttime);
                this.appLogQueryCriteria.before(endtime);
            }
        }
        this.appLogQueryCriteria.returnXML();
    }

    @Override
    public Map<String, String> getJobLogs(String jobId) throws CoreException {
        if (this.jobLogCache.containsKey(jobId)) {
            return this.jobLogCache.get(jobId);
        }
        ApplicationManager appManager = this.createApplicationManager();
        try {
            Job job = appManager.describeJob(jobId);
            Map<String, String> logs = this.getJobLogs((JobManager)appManager, job);
            if (!job.getStatus().equals((Object)JobStatus.RUNNING)) {
                this.jobLogCache.put(jobId, logs);
            }
            return logs;
        }
        catch (ManagerException managerException) {
            return Collections.emptyMap();
        }
    }

    @Override
    public HashMap describeApplication(String tenantName, String serviceName, String name) throws CoreException {
        ApplicationManager appManager = this.createApplicationManager();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Application app = appManager.describeApplication(tenantName, serviceName, name);
        String appName = app.getApplicationName();
        ret.put("Name", appName == null ? "" : appName);
        ret.put("Type", app.getType().toString());
        ret.put("URLs", app.getApplicationUrls() == null ? new ArrayList() : app.getApplicationUrls());
        HashMap<String, String> kv = new HashMap<String, String>();
        for (Property p : app.getProperties()) {
            kv.put(p.getName(), p.getValue());
        }
        ret.put("Properties", kv);
        ret.put("State", app.getState().toString());
        return ret;
    }

    @Override
    public List<String> listDataSources() throws CoreException {
        ArrayList<String> ret = new ArrayList<String>();
        ApplicationManager appManager = this.createApplicationManager();
        List dss = appManager.listDataSources(this.runtime.getTenantName(), this.runtime.getServiceName());
        for (DataSource ds : dss) {
            ret.add(ds.getName());
        }
        return ret;
    }

    public static void main(String[] args) throws CoreException {
        System.setProperty("java.net.preferIPv4Stack", "true");
        final String adminUrl = args[0];
        final String identityDomain = args[1];
        final String user = args[2];
        final String passwd = args[3];
        final String sg = args[4];
        final String si = args[5];
        System.setProperty("https.proxyHost", "www-proxy.us.oracle.com");
        System.setProperty("https.proxyPort", "80");
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Connection conn = NuviaqDeployer.createConnection(adminUrl, identityDomain, user, passwd);
                            ApplicationManager appManager = conn.getApplicationManager();
                            List apps = appManager.listApplications(sg, si);
                            System.out.println("Total applications " + apps.size());
                            appManager.release();
                            Thread.sleep(5000L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                    }
                    break;
                }
            }
        };
        t.start();
    }

    @Override
    public IStatus undeployLibrary(Library lib, IProgressMonitor monitor) throws AuthenticationException, CoreException {
        Map<String, Library> modules = this.listLibraries();
        if (modules.get(lib.getVersionedName()) == null) {
            return Status.OK_STATUS;
        }
        LibraryManager libManager = this.createLibraryManager();
        try {
            Job Job2 = libManager.undeployLibrary(lib);
            String jobId = Job2.getJobId();
            JobStatus status = Job2.getStatus();
            String msg = "Waiting for deployment job " + jobId;
            msg = String.valueOf(msg) + ". Check the status using Oracle Cloud Java Service Logs.";
            monitor.subTask(msg);
            while (!(status.equals((Object)JobStatus.FAILED) || status.equals((Object)JobStatus.COMPLETE) || status.equals((Object)JobStatus.CANCELLED))) {
                monitor.worked(20);
                Thread.sleep(1000L);
                Job2 = libManager.describeJob(jobId);
                status = Job2.getStatus();
                if (!monitor.isCanceled()) continue;
                return CloudPlugin.createErrorStatus("Deployment to Oracle Cloud canceled", null);
            }
            if (status.equals((Object)JobStatus.FAILED)) {
                String msg1 = this.fetchJobLog((JobManager)libManager, Job2);
                return CloudPlugin.createErrorStatus("Undeploy library failed, please check Error Log for detail.", new Exception(msg1));
            }
        }
        catch (ResourceBusyException re) {
            ServerBusyException se = new ServerBusyException("Cloud server instance is busy", (Exception)((Object)re));
            Job activeJob = re.getActiveJob();
            String msg = "The active job id is " + activeJob.getJobId();
            throw new CoreException(CloudPlugin.createErrorStatus("Cloud server instance is busy. " + msg + ". Please wait for the running job finishes and try later.", se));
        }
        catch (ManagerException me) {
            return this.handleNuviaqException((JobManager)libManager, me);
        }
        catch (InterruptedException interruptedException) {}
        return Status.OK_STATUS;
    }

    @Override
    public IStatus installLibrary(Library library, InputStream libraryArchive, IProgressMonitor monitor) throws AuthenticationException, CoreException {
        LibraryManager libManager = this.createLibraryManager();
        try {
            Job job = libManager.deployLibrary(library, libraryArchive);
            String jobId = job.getJobId();
            JobStatus status = job.getStatus();
            String msg = "Waiting for deployment job " + jobId;
            msg = String.valueOf(msg) + ". Check the status using Oracle Cloud Java Service Logs.";
            monitor.subTask(msg);
            while (!(status.equals((Object)JobStatus.FAILED) || status.equals((Object)JobStatus.COMPLETE) || status.equals((Object)JobStatus.CANCELLED))) {
                monitor.worked(20);
                Thread.sleep(1000L);
                job = libManager.describeJob(jobId);
                status = job.getStatus();
                if (!monitor.isCanceled()) continue;
                return CloudPlugin.createErrorStatus("Deployment to Oracle Cloud canceled", null);
            }
            if (status.equals((Object)JobStatus.FAILED)) {
                String msg1 = this.fetchJobLog((JobManager)libManager, job);
                return CloudPlugin.createErrorStatus("Install library failed, please check Error Log for detail.", new Exception(msg1));
            }
        }
        catch (oracle.cloud.paas.exception.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), (Exception)((Object)ae));
        }
        catch (ManagerException me) {
            return this.handleNuviaqException((JobManager)libManager, me);
        }
        catch (InterruptedException interruptedException) {}
        return Status.OK_STATUS;
    }

    @Override
    public IStatus redeployLibrary(Library library, InputStream libraryArchive, IProgressMonitor monitor) throws AuthenticationException, CoreException {
        LibraryManager libManager = this.createLibraryManager();
        try {
            Job job = libManager.redeployLibrary(library, libraryArchive);
            String jobId = job.getJobId();
            JobStatus status = job.getStatus();
            String msg = "Waiting for deployment job " + jobId;
            msg = String.valueOf(msg) + ". Check the status using Oracle Cloud Java Service Logs.";
            monitor.subTask(msg);
            while (!(status.equals((Object)JobStatus.FAILED) || status.equals((Object)JobStatus.COMPLETE) || status.equals((Object)JobStatus.CANCELLED))) {
                monitor.worked(20);
                Thread.sleep(1000L);
                job = libManager.describeJob(jobId);
                status = job.getStatus();
                if (!monitor.isCanceled()) continue;
                return CloudPlugin.createErrorStatus("Deployment to Oracle Cloud canceled", null);
            }
            if (status.equals((Object)JobStatus.FAILED)) {
                String msg1 = this.fetchJobLog((JobManager)libManager, job);
                return CloudPlugin.createErrorStatus("Install library failed, please check Error Log for detail.", new Exception(msg1));
            }
        }
        catch (oracle.cloud.paas.exception.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), (Exception)((Object)ae));
        }
        catch (ManagerException me) {
            return this.handleNuviaqException((JobManager)libManager, me);
        }
        catch (InterruptedException interruptedException) {}
        return Status.OK_STATUS;
    }

    private ServiceManager createServiceManager() throws CoreException {
        String adminUrl = this.runtime.getAdminUrl();
        String password = this.runtime.getPassword();
        String identityDoamin = this.runtime.getTenantName();
        String userName = this.runtime.getUserName();
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("identitydomain", identityDoamin);
            properties.put("serviceinstance", this.runtime.getServiceName());
            ServiceManager manager = ServiceManagerFactory.createServiceManager((String)"javacloud-rest", (String)adminUrl, (String)userName, (byte[])password.getBytes(StandardCharsets.UTF_8), properties);
            return manager;
        }
        catch (Exception e) {
            throw new CoreException(CloudPlugin.createErrorStatus("Error initialize SSL settings", e));
        }
    }

    @Override
    public List<CertificateDescription> listSSLCertificates() throws CoreException, ServiceException {
        CertificateService c = this.getCertificateService(INuviaqDeployer.CERTIFICATE_SERVICE_TYPE.SSL);
        List list = c.listCertificates();
        return list;
    }

    @Override
    public List<CertificateDescription> listWSSCertificates() throws CoreException, ServiceException {
        return this.listWSSCertificates(null, null);
    }

    public List<CertificateDescription> listWSSCertificates(String stripeName, String keystoreName) throws CoreException, ServiceException {
        CertificateService c = this.getCertificateService(INuviaqDeployer.CERTIFICATE_SERVICE_TYPE.OWSM_WSS);
        List list = c.listCertificates();
        return list;
    }

    @Override
    public CertificateService getCertificateService(INuviaqDeployer.CERTIFICATE_SERVICE_TYPE type) throws CoreException, ServiceException {
        ServiceManager manager = this.createServiceManager();
        try {
            if (type == INuviaqDeployer.CERTIFICATE_SERVICE_TYPE.SSL) {
                CertificateService c;
                ResourceManagerService res = (ResourceManagerService)manager.getService(ResourceManagerService.class);
                CertificateService certificateService = c = ((SSLService)res.getResourceService(SSLService.class)).getSSLTrustService();
                return certificateService;
            }
            if (type == INuviaqDeployer.CERTIFICATE_SERVICE_TYPE.OWSM_WSS) {
                CertificateService c;
                KeyStoreManagerService res = (KeyStoreManagerService)manager.getService(KeyStoreManagerService.class);
                CertificateService certificateService = c = res.getDomainLevelTrustService();
                return certificateService;
            }
        }
        finally {
            try {
                manager.close();
            }
            catch (IOException e) {
                CloudPlugin.log(e);
            }
        }
        return null;
    }

    @Override
    public Job restartServiceInstance() throws CoreException, ServiceException {
        String identityDomain = this.runtime.getTenantName();
        String serviceName = this.runtime.getServiceName();
        ApplicationManager appMgr = this.createApplicationManager();
        Job job = appMgr.restartService(identityDomain, serviceName, true);
        return job;
    }

    @Override
    public boolean isServiceInstanceRestarting() throws CoreException {
        List<Job> list = this.getRunningJobs();
        for (Job job : list) {
            if (!job.getOperation().startsWith("Restart")) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isJobRunning(String id) {
        try {
            Job job;
            List<Job> list = this.getRunningJobs();
            Iterator<Job> iterator = list.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(job = iterator.next()).getJobId().equals(id));
            return true;
        }
        catch (CoreException coreException) {}
        return false;
    }

    public List<Job> getRunningJobs() throws CoreException {
        String identityDomain = this.runtime.getTenantName();
        String serviceName = this.runtime.getServiceName();
        ApplicationManager appMgr = this.createApplicationManager();
        try {
            JobQuery query = JobQueryBuilder.createBuilder().identityDomain(identityDomain).service(serviceName).status(JobStatus.RUNNING).build();
            List list = appMgr.listJobs(query);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

