/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.profile;

import java.io.File;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.cloud.ApacheHttpClient;
import oracle.eclipse.tools.cloud.AuthenticationException;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.CloudServiceClient;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.OPC132PortalWebUIParser;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sapphire.modeling.Status;

public class OPCPortalServiceClient
extends CloudServiceClient {
    String DEFAULT_BASE_URL = "cloud.oracle.com";
    String CLOUD_SERVICE_URL = "https://myservices.%s.%s/mycloud/f?p=my_services";
    public static final String OPC131_PORTAL_LIST_TABLE = "<table class=\"mysListReport\"";
    public static final String OPC132_SERVICE_LINK = "<a id=\"pt1:sections:";
    public static final String MSG_ACCOUNT_LOCKED_OUT = "Your account is locked. ";

    public OPCPortalServiceClient(ICloudProfile profile) {
        super(profile);
    }

    public OPCPortalServiceClient(CloudConnection connection) {
        super(connection);
    }

    protected ApacheHttpClient.ResponseData login() {
        String url = String.format(this.CLOUD_SERVICE_URL, this.dataCenter, this.DEFAULT_BASE_URL);
        if (this.connection != null) {
            ICloudProfile profile = this.connection.profile();
            String baseUrl = (String)profile.getBaseUrl().content();
            String cloudPortalUrl = (String)profile.getCloudPortalUrl().content();
            if (!baseUrl.equals(this.DEFAULT_BASE_URL) || !url.equals(cloudPortalUrl)) {
                url = cloudPortalUrl;
            }
        }
        return this.login(url);
    }

    @Override
    public Status validate(IProgressMonitor mon) {
        int beginIndex;
        ApacheHttpClient.ResponseData rd = this.login();
        if (rd.statusCode == 401) {
            return Status.createErrorStatus((String)"Connection to Oracle Cloud service failed. Please check your connection information including user name, password and data center.", null);
        }
        if (rd.statusCode != 200) {
            return Status.createErrorStatus((String)("Connection to Oracle Cloud service failed.\n" + rd.getExceptionMessage()), (Throwable)rd.exception);
        }
        mon.worked(100);
        String responseBody = rd.bodyText;
        if (responseBody == null || responseBody.length() == 0) {
            return Status.createErrorStatus((String)("Connection to Oracle Cloud service failed.\n" + rd.getExceptionMessage()), (Throwable)rd.exception);
        }
        if (responseBody.indexOf(MSG_ACCOUNT_LOCKED_OUT) >= 0) {
            return Status.createErrorStatus((String)("Your account is locked. You can unlock your account in Cloud Portal.\n" + rd.getExceptionMessage()), (Throwable)rd.exception);
        }
        if (OracleCloudTools.isDebugMode()) {
            try {
                File temp = File.createTempFile("oepe-cloud-portal", ".txt");
                FileUtil.writeTextFile((File)temp, (String)responseBody);
            }
            catch (Exception exception) {}
        }
        if ((beginIndex = responseBody.indexOf(OPC132_SERVICE_LINK)) < 0) {
            return Status.factoryForLeaf().message("Unsupported Oracle Cloud version.").type("Oracle.Cloud.UnsupportedVersion").severity(Status.Severity.ERROR).create();
        }
        return Status.createOkStatus();
    }

    @Override
    public List<ServiceDesc> getServices(IProgressMonitor mon) {
        mon.worked(100);
        ApacheHttpClient.ResponseData rd = this.login();
        if (rd.statusCode == 401) {
            throw new AuthenticationException("Invalid user name or password.", null);
        }
        String responseBody = rd.bodyText;
        if (responseBody == null || responseBody.length() == 0) {
            return Collections.emptyList();
        }
        if (responseBody.indexOf(MSG_ACCOUNT_LOCKED_OUT) >= 0) {
            throw new AuthenticationException(MSG_ACCOUNT_LOCKED_OUT, null);
        }
        mon.worked(100);
        int beginIndex = responseBody.indexOf(OPC131_PORTAL_LIST_TABLE);
        if (beginIndex > 0) {
            return Collections.emptyList();
        }
        if (responseBody.indexOf(OPC132_SERVICE_LINK) > 0) {
            return OPC132PortalWebUIParser.parse(this.connection, responseBody, mon);
        }
        return Collections.emptyList();
    }
}

