/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.JavaServiceDesc;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import org.eclipse.core.runtime.IProgressMonitor;

public class OPC132PortalWebUIParser {
    public static List<ServiceDesc> parse(CloudConnection connection, String responseBody, IProgressMonitor mon) {
        ICloudProfile profile = connection.profile();
        ArrayList<ServiceDesc> ret = new ArrayList<ServiceDesc>();
        int beginIndex = responseBody.indexOf("<a id=\"pt1:sections:");
        if (beginIndex < 0) {
            return Collections.emptyList();
        }
        String serviceDetail = responseBody.substring(beginIndex);
        int endIndex = serviceDetail.indexOf("<span id=\"pt1:footer:footer\"");
        if (endIndex == -1) {
            endIndex = serviceDetail.length() - 1;
        }
        serviceDetail = serviceDetail.substring(0, endIndex);
        String portalUrl = (String)profile.getCloudPortalUrl().content();
        String portalBaseUrl = null;
        Pattern urlPattern = Pattern.compile("http.?://.*?/");
        Matcher urlMatcher = urlPattern.matcher(portalUrl);
        if (urlMatcher.find()) {
            portalBaseUrl = urlMatcher.group();
        }
        mon.worked(100);
        String serviceRowPatternString = String.format("<a id=\"pt1:sections:.*?>(.*?)</a>", new Object[0]);
        Pattern serviceRowPattern = Pattern.compile(serviceRowPatternString);
        String serviceLinkString = "href=\".*?\">";
        Pattern serviceLinkPattern = Pattern.compile(serviceLinkString);
        Matcher linkMatch = serviceRowPattern.matcher(serviceDetail);
        while (linkMatch.find()) {
            String[] values;
            String hrefTag = linkMatch.group();
            int n1 = hrefTag.indexOf("\">");
            int n2 = hrefTag.indexOf("</a>");
            String serviceNameAndTYype = hrefTag.substring(n1 + 2, n2);
            if (OracleCloudTools.isDebugCloudPortal()) {
                System.out.println(serviceNameAndTYype);
            }
            if ((values = serviceNameAndTYype.split("[\\(\\)]")).length < 2) continue;
            String name = values[0].trim();
            String type = values[1].trim();
            StringBuilder serverLinkUrl = new StringBuilder();
            if (portalBaseUrl != null) {
                Matcher serviceLinkMatcher = serviceLinkPattern.matcher(hrefTag);
                if (serviceLinkMatcher.find()) {
                    String[] segments;
                    String s = serviceLinkMatcher.group();
                    String hrefText = s.substring("href=\"".length(), s.length() - 2);
                    String detailPagePath = hrefText.substring(1, hrefText.indexOf(63) + 1);
                    serverLinkUrl.append(portalBaseUrl);
                    serverLinkUrl.append(detailPagePath);
                    String[] stringArray = segments = hrefText.split("&amp;");
                    int n = segments.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String seg = stringArray[n3];
                        if (seg.startsWith("serviceId=")) {
                            serverLinkUrl.append(seg);
                            break;
                        }
                        ++n3;
                    }
                }
            } else {
                serverLinkUrl.append(portalUrl);
            }
            String serverLinkUrlStr = serverLinkUrl.toString();
            if (type.equals("Java")) {
                ret.add(new JavaServiceDesc(connection, name, serverLinkUrlStr));
                continue;
            }
            if (type.equals("Developer")) {
                ret.add(new DevServiceDesc(connection, name, serverLinkUrlStr, profile));
                continue;
            }
            if (!type.equals("Database")) continue;
            ret.add(new ServiceDesc(connection, name, ServiceDesc.TYPE.DB, serverLinkUrlStr));
        }
        mon.worked(100);
        return ret;
    }
}

