/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.maven.pom;

import java.io.File;
import oracle.eclipse.tools.cloud.maven.pom.IMavenProjectModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.FileResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public class PomModelFactory {
    public static IMavenProjectModel getMavenProjectModel(File file, String groupId, String artifactId, String packaging) {
        IMavenProjectModel model = null;
        try {
            model = PomModelFactory.load(file);
            if (!file.exists()) {
                model.resource().save();
            }
            model.setModelVersion("4.0.0");
            model.setGroupId(groupId);
            model.setArtifactId(artifactId);
            model.setName(artifactId);
            model.setPackaging(packaging);
        }
        catch (ResourceStoreException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static IMavenProjectModel getMavenProjectModel(IFile file, String groupId, String artifactId, String packaging) {
        IMavenProjectModel model = null;
        try {
            model = PomModelFactory.loadWorkspaceFile(file);
            if (!file.exists()) {
                model.setModelVersion("4.0.0");
                model.setVersion("1.0.0-SNAPSHOT");
                model.setGroupId(groupId);
                model.setArtifactId(artifactId.replace('.', '-'));
                model.setName(artifactId.replace('.', '-'));
                model.setPackaging(packaging);
                model.resource().save();
            }
        }
        catch (ResourceStoreException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static IMavenProjectModel load(File file) throws ResourceStoreException {
        return PomModelFactory.load(new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(file)));
    }

    public static IMavenProjectModel loadWorkspaceFile(IFile file) throws ResourceStoreException {
        return PomModelFactory.load(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
    }

    public static IMavenProjectModel load(XmlResourceStore resourceStore) {
        return (IMavenProjectModel)IMavenProjectModel.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
    }
}

