/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.log;

import java.util.HashMap;
import oracle.eclipse.tools.cloud.log.IServiceInstanceLogEntry;
import oracle.eclipse.tools.cloud.log.Severity;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;

public class LogMessageImageService
extends ImageService {
    private HashMap<Severity, ImageData> cache = new HashMap();
    private Listener listener;

    protected ImageData compute() {
        ImageData image = null;
        IServiceInstanceLogEntry log = (IServiceInstanceLogEntry)this.context(IServiceInstanceLogEntry.class);
        Severity s = (Severity)((Object)log.getSeverity().content());
        if (s != null) {
            if (this.cache.get((Object)s) == null) {
                String imageResourceName = String.valueOf(((Severity)((Object)log.getSeverity().content())).toString().toLowerCase()) + ".gif";
                if (imageResourceName != null) {
                    String imageResourcePath = "oracle/eclipse/tools/cloud/log/" + imageResourceName;
                    image = (ImageData)ImageData.readFromClassLoader(LogMessageImageService.class, (String)imageResourcePath).required();
                    this.cache.put(s, image);
                }
            } else {
                image = this.cache.get((Object)s);
            }
        }
        return image;
    }

    protected void initImageService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                LogMessageImageService.this.refresh();
            }
        };
        ((IServiceInstanceLogEntry)this.context(IServiceInstanceLogEntry.class)).getSeverity().attach(this.listener);
    }

    public void dispose() {
        super.dispose();
        IServiceInstanceLogEntry model = (IServiceInstanceLogEntry)this.context(IServiceInstanceLogEntry.class);
        if (!model.disposed()) {
            model.getSeverity().detach(this.listener);
        }
    }
}

