/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.log;

import oracle.eclipse.tools.cloud.log.IStatusEnumItem;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Validation;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@XmlBinding(path="query-criteria")
public interface IJobsLogQueryCriteria
extends Element {
    public static final ElementType TYPE = new ElementType(IJobsLogQueryCriteria.class);
    @Label(standard="&application name")
    @XmlBinding(path="app-name")
    @Documentation(content="The list of application names. Multiple values can be passed with a comma(,) as the separator.")
    public static final ValueProperty PROP_APP = new ValueProperty(TYPE, "App");
    @Label(standard="&limit")
    @DefaultValue(text="100")
    @Type(base=Integer.class)
    @Validation(rule="${ Limit > 0 }", message="Limit must be greater than 0.")
    @Documentation(content="The max number of search records to be returned. If the value is not specified or the specified value is not a positive integer, the tool does not request for limiting the search results. The default value is determined by Oracle Cloud.")
    public static final ValueProperty PROP_LIMIT = new ValueProperty(TYPE, "Limit");
    @Label(standard="&status")
    @CountConstraint(min=1)
    @Type(base=IStatusEnumItem.class)
    @XmlListBinding(path="job-status", mappings={@XmlListBinding.Mapping(element="status", type=IStatusEnumItem.class)})
    @Documentation(content="The status of the jobs.")
    public static final ListProperty PROP_STATUS = new ListProperty(TYPE, "Status");

    public void setApp(String var1);

    public Value<String> getApp();

    public void setLimit(String var1);

    public void setLimit(Integer var1);

    public Value<Integer> getLimit();

    public ElementList<IStatusEnumItem> getStatus();
}

