/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.log;

import oracle.eclipse.tools.cloud.log.ISeverityEnumItem;
import oracle.eclipse.tools.cloud.log.LastType;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Validation;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface IAppLogQueryCriteria
extends Element {
    public static final ElementType TYPE = new ElementType(IAppLogQueryCriteria.class);
    @Label(standard="sid")
    public static final ValueProperty PROP_RUNTIME_ID = new ValueProperty(TYPE, "RuntimeId");
    @Label(standard="&application name")
    @XmlBinding(path="app-name")
    @Documentation(content="The list of application names. Multiple values can be passed with a comma(,) as the separator.")
    public static final ValueProperty PROP_APP = new ValueProperty(TYPE, "App");
    @Label(standard="&contains")
    @XmlBinding(path="contain-value")
    @Documentation(content="The list of tokens to be found in each log record that will be returned.")
    public static final ValueProperty PROP_CONTAIN = new ValueProperty(TYPE, "Contain");
    @Label(standard="&limit")
    @DefaultValue(text="100")
    @Type(base=Integer.class)
    @Validation(rule="${ Limit > 0 }", message="Limit must be greater than 0.")
    @Documentation(content="The max number of search records to be returned. If the value is not specified or the specified value is not a positive integer, the tool does not request for limiting the search results. The default value is determined by Oracle Cloud.")
    public static final ValueProperty PROP_LIMIT = new ValueProperty(TYPE, "Limit");
    @Label(standard="time &scope")
    @Type(base=Integer.class)
    @XmlBinding(path="last-value")
    @NumericRange(min="1")
    @Documentation(content="The last time scope within which the search has to be performed.")
    public static final ValueProperty PROP_LAST_VALUE = new ValueProperty(TYPE, "LastValue");
    @Label(standard="last type")
    @Type(base=LastType.class)
    @DefaultValue(text="DAYS")
    @XmlBinding(path="last-type")
    public static final ValueProperty PROP_LAST_TYPE = new ValueProperty(TYPE, "LastType");
    @Label(standard="se&verity")
    @CountConstraint(min=1)
    @Type(base=ISeverityEnumItem.class)
    @XmlListBinding(path="severities", mappings={@XmlListBinding.Mapping(element="severity", type=ISeverityEnumItem.class)})
    @Documentation(content="The severity of the log messages.")
    public static final ListProperty PROP_SEVERITIES = new ListProperty(TYPE, "Severities");

    public void setRuntimeId(String var1);

    public Value<String> getRuntimeId();

    public void setApp(String var1);

    public Value<String> getApp();

    public void setContain(String var1);

    public Value<String> getContain();

    public void setLimit(String var1);

    public void setLimit(Integer var1);

    public Value<Integer> getLimit();

    public void setLastValue(String var1);

    public void setLastValue(Integer var1);

    public Value<Integer> getLastValue();

    public void setLastType(String var1);

    public void setLastType(LastType var1);

    public Value<LastType> getLastType();

    public ElementList<ISeverityEnumItem> getSeverities();
}

