/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.log.IServiceInstanceLogEntry;
import oracle.eclipse.tools.cloud.log.IServiceInstanceLogModel;
import oracle.eclipse.tools.cloud.log.ServiceInstanceLogModelFactory;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

class ApplicationLogModelResource
extends Resource {
    private IServer server = null;
    private String filterText = null;

    public ApplicationLogModelResource(IServer newServer) {
        super(null);
        this.server = newServer;
    }

    public void save() throws ResourceStoreException {
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IServiceInstanceLogModel.PROP_LOGS) {
            return this.createLogList(property);
        }
        if (p == IServiceInstanceLogModel.PROP_FILTER_TEXT) {
            return new ValuePropertyBinding(){

                public void write(String value) {
                    ApplicationLogModelResource.this.filterText = value;
                }

                public String read() {
                    return ApplicationLogModelResource.this.filterText;
                }
            };
        }
        if (p == IServiceInstanceLogModel.PROP_SERVER_ID) {
            return new ValuePropertyBinding(){

                public void write(String value) {
                }

                public String read() {
                    return ApplicationLogModelResource.this.server.getName();
                }
            };
        }
        return null;
    }

    private PropertyBinding createLogList(final Property property) {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<?> readUnderlyingList() {
                OracleCloudServer wlsServer;
                if (ApplicationLogModelResource.this.server.getServerState() != 4 && (wlsServer = (OracleCloudServer)((Object)ApplicationLogModelResource.this.server.loadAdapter(OracleCloudServer.class, (IProgressMonitor)new NullProgressMonitor()))) != null) {
                    Map<IServer, List> map = ServiceInstanceLogModelFactory.serverAppLogCache;
                    synchronized (map) {
                        List logList = ServiceInstanceLogModelFactory.serverAppLogCache.get(ApplicationLogModelResource.this.server);
                        if (logList != null) {
                            return this.filterJobList(logList);
                        }
                        Job job = new Job("Loading application log"){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    IRuntime rt = ApplicationLogModelResource.this.server.getRuntime();
                                    if (rt != null) {
                                        OracleCloudRuntime crt = (OracleCloudRuntime)((Object)rt.loadAdapter(OracleCloudRuntime.class, null));
                                        INuviaqDeployer deployer = crt.getNuviaqDeployer();
                                        List<Map<String, String>> list = deployer.listApplicationLogs();
                                        ServiceInstanceLogModelFactory.serverAppLogCache.put(ApplicationLogModelResource.this.server, list);
                                        final IServiceInstanceLogModel modeElement = (IServiceInstanceLogModel)property.element();
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                modeElement.refresh();
                                            }
                                        });
                                    }
                                }
                                catch (Exception e) {
                                    CloudPlugin.log(e);
                                }
                                return StatusBridge.create((Status)Status.createOkStatus());
                            }
                        };
                        job.schedule();
                    }
                }
                return new ArrayList();
            }

            private List<Map<String, String>> filterJobList(List<Map<String, String>> jobList) {
                if (ApplicationLogModelResource.this.filterText != null && ApplicationLogModelResource.this.filterText.trim().length() > 0) {
                    ArrayList<Map<String, String>> filteredJobList = new ArrayList<Map<String, String>>();
                    block0: for (Map<String, String> jobLog : jobList) {
                        for (String val : jobLog.values()) {
                            if (val == null || !val.toLowerCase().contains(ApplicationLogModelResource.this.filterText.toLowerCase())) continue;
                            filteredJobList.add(Collections.unmodifiableMap(jobLog));
                            continue block0;
                        }
                    }
                    return filteredJobList;
                }
                return jobList;
            }

            public void remove(Resource resource) {
            }

            protected Resource resource(Object obj) {
                Map map = (Map)obj;
                return new LogResource(ApplicationLogModelResource.this, map);
            }

            public ElementType type(Resource obj) {
                return IServiceInstanceLogEntry.TYPE;
            }
        };
        return listBinding;
    }

    static class LogResource
    extends Resource {
        Map<String, String> map = null;

        public LogResource(Resource parent, Map<String, String> map) {
            super(parent);
            this.map = map;
        }

        protected PropertyBinding createBinding(Property property) {
            PropertyDef p = property.definition();
            if (p == IServiceInstanceLogEntry.PROP_LEVEL) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return LogResource.this.map.get("level");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == IServiceInstanceLogEntry.PROP_TIMESTAMP) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return LogResource.this.map.get("timestamp");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == IServiceInstanceLogEntry.PROP_SEVERITY) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return LogResource.this.map.get("severity");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == IServiceInstanceLogEntry.PROP_MESSAGE) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return LogResource.this.map.get("message");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == IServiceInstanceLogEntry.PROP_DETAILS) {
                return new ValuePropertyBinding(){

                    public String read() {
                        String details = LogResource.this.map.get("details");
                        return details;
                    }

                    public void write(String value) {
                    }
                };
            }
            return null;
        }
    }
}

