/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.log;

import java.io.File;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.log.IAppLogQueryCriteria;
import oracle.eclipse.tools.cloud.log.ICloudAppLogQueryCriteria;
import oracle.eclipse.tools.cloud.log.ISeverityEnumItem;
import oracle.eclipse.tools.cloud.log.Severity;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import org.eclipse.core.resources.IFile;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public class AppLogQueryCriteriaFactory {
    public static IAppLogQueryCriteria getInstance(OracleCloudRuntime rt) {
        ICloudAppLogQueryCriteria cloudAppLogQueryCriteria = null;
        File stateLoc = CloudPlugin.state().toFile();
        IAppLogQueryCriteria appLogQueryCriteria = null;
        try {
            String runtimeId = rt.getRuntime().getId();
            File f = new File(stateLoc, "cloud-apps-log-query-criteria.xml");
            cloudAppLogQueryCriteria = AppLogQueryCriteriaFactory.load(f);
            if (!f.exists()) {
                appLogQueryCriteria = AppLogQueryCriteriaFactory.createAppLogQueryCriteria(cloudAppLogQueryCriteria, runtimeId);
            } else {
                for (IAppLogQueryCriteria c : cloudAppLogQueryCriteria.getCriteria()) {
                    if (!((String)c.getRuntimeId().content()).equals(rt.getRuntime().getId())) continue;
                    return c;
                }
                appLogQueryCriteria = AppLogQueryCriteriaFactory.createAppLogQueryCriteria(cloudAppLogQueryCriteria, runtimeId);
            }
            cloudAppLogQueryCriteria.resource().save();
        }
        catch (ResourceStoreException e) {
            CloudPlugin.log((Exception)((Object)e));
        }
        return appLogQueryCriteria;
    }

    private static IAppLogQueryCriteria createAppLogQueryCriteria(ICloudAppLogQueryCriteria cloudAppLogQueryCriteria, String id) {
        IAppLogQueryCriteria appLogQueryCriteria = (IAppLogQueryCriteria)cloudAppLogQueryCriteria.getCriteria().insert();
        appLogQueryCriteria.setRuntimeId(id);
        appLogQueryCriteria.setLimit(100);
        ISeverityEnumItem item = (ISeverityEnumItem)appLogQueryCriteria.getSeverities().insert();
        item.setItem(Severity.WARNING);
        item = (ISeverityEnumItem)appLogQueryCriteria.getSeverities().insert();
        item.setItem(Severity.ERROR);
        item = (ISeverityEnumItem)appLogQueryCriteria.getSeverities().insert();
        item.setItem(Severity.INCIDENT_ERROR);
        return appLogQueryCriteria;
    }

    public static ICloudAppLogQueryCriteria load(File file) throws ResourceStoreException {
        return AppLogQueryCriteriaFactory.load(new XmlResourceStore(file));
    }

    public static ICloudAppLogQueryCriteria load(IFile file) throws ResourceStoreException {
        return AppLogQueryCriteriaFactory.load(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
    }

    public static ICloudAppLogQueryCriteria load(XmlResourceStore resourceStore) {
        return (ICloudAppLogQueryCriteria)ICloudAppLogQueryCriteria.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
    }
}

