/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.job;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.job.Job;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class JcsJobs
extends RemoteData<List<Job>> {
    IServer server = null;

    public JcsJobs(IServer server) {
        super("Java Service Instance Jobs", null, new RemoteData.BackgroundFetcher(30, TimeUnit.SECONDS));
        this.server = server;
    }

    @Override
    protected List<Job> read() throws Exception {
        IRuntime rt = this.server.getRuntime();
        if (rt == null) {
            throw new RuntimeException("Error retrieving Cloud Jobs");
        }
        OracleCloudRuntime crt = (OracleCloudRuntime)((Object)rt.loadAdapter(OracleCloudRuntime.class, null));
        if (crt == null) {
            throw new RuntimeException("Error retrieving Cloud Jobs");
        }
        INuviaqDeployer deployer = crt.getNuviaqDeployer();
        List<Map<String, String>> list = deployer.listJobs();
        Collections.reverse(list);
        ListFactory ret = ListFactory.start();
        for (Map<String, String> map : list) {
            ret.add((Object)new Job(map));
        }
        return ret.result();
    }
}

