/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.cloud.ICloudJob;
import oracle.eclipse.tools.cloud.ICloudServerJobsLogModel;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.job.JcsJobs;
import oracle.eclipse.tools.cloud.job.Job;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IServer;

public class CloudServerModelResource
extends Resource {
    private IServer server = null;
    private String filterText = null;
    Listener jobsFectcherListener;
    JcsJobs jcsJobs = null;

    public CloudServerModelResource(IServer newServer) {
        super(null);
        this.server = newServer;
        this.jcsJobs = new JcsJobs(this.server);
    }

    public IServer server() {
        return this.server;
    }

    public JcsJobs jcsJobs() {
        return this.jcsJobs;
    }

    public void save() throws ResourceStoreException {
    }

    public void dispose() {
        super.dispose();
        this.jcsJobs.dispose();
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == ICloudServerJobsLogModel.PROP_JOBS) {
            return this.createJobList(property);
        }
        if (p == ICloudServerJobsLogModel.PROP_FILTER_TEXT) {
            return new ValuePropertyBinding(){

                public void write(String value) {
                    CloudServerModelResource.this.filterText = value;
                }

                public String read() {
                    return CloudServerModelResource.this.filterText;
                }
            };
        }
        return null;
    }

    private PropertyBinding createJobList(final Property property) {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){

            protected List<Job> readUnderlyingList() {
                OracleCloudServer wlsServer;
                if (CloudServerModelResource.this.server.getServerState() != 4 && (wlsServer = (OracleCloudServer)((Object)CloudServerModelResource.this.server.loadAdapter(OracleCloudServer.class, (IProgressMonitor)new NullProgressMonitor()))) != null) {
                    if (CloudServerModelResource.this.jobsFectcherListener == null) {
                        CloudServerModelResource.this.jobsFectcherListener = new FilteredListener<RemoteData.ContentEvent>(){

                            protected void handleTypedEvent(RemoteData.ContentEvent event) {
                                final ICloudServerJobsLogModel modeElement = (ICloudServerJobsLogModel)property.element();
                                if (modeElement.disposed()) {
                                    return;
                                }
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        modeElement.refresh();
                                    }
                                });
                            }
                        };
                    }
                    CloudServerModelResource.this.jcsJobs.attach(CloudServerModelResource.this.jobsFectcherListener);
                    if (CloudServerModelResource.this.jcsJobs.available()) {
                        return this.filterJobList((List)CloudServerModelResource.this.jcsJobs.content());
                    }
                    CloudServerModelResource.this.jcsJobs.fetch(true, null);
                    return Collections.emptyList();
                }
                return Collections.emptyList();
            }

            private List<Job> filterJobList(List<Job> jobList) {
                if (CloudServerModelResource.this.filterText != null && CloudServerModelResource.this.filterText.trim().length() > 0) {
                    ArrayList<Job> filteredJobList = new ArrayList<Job>();
                    block0: for (Job job : jobList) {
                        Map<String, String> jobLog = job.getMap();
                        for (String val : jobLog.values()) {
                            if (val == null || !val.toLowerCase().contains(CloudServerModelResource.this.filterText.toLowerCase())) continue;
                            filteredJobList.add(job);
                            continue block0;
                        }
                    }
                    return filteredJobList;
                }
                return jobList;
            }

            public void remove(Resource resource) {
            }

            protected Resource resource(Object obj) {
                Job job = (Job)obj;
                return new JobResource(CloudServerModelResource.this, job);
            }

            public ElementType type(Resource obj) {
                return ICloudJob.TYPE;
            }
        };
        return listBinding;
    }

    static class JobResource
    extends Resource {
        Map<String, String> map = null;

        public JobResource(Resource parent, Job job) {
            super(parent);
            this.map = job.getMap();
        }

        protected PropertyBinding createBinding(Property property) {
            PropertyDef p = property.definition();
            if (p == ICloudJob.PROP_ID) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return JobResource.this.map.get("jobId");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == ICloudJob.PROP_START_TIME) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return JobResource.this.map.get("startTime");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == ICloudJob.PROP_END_TIME) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return JobResource.this.map.get("endTime");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == ICloudJob.PROP_DURATION) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return JobResource.this.map.get("duration");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == ICloudJob.PROP_LAST_UPDATE_TIME) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return JobResource.this.map.get("lastUpdateTime");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == ICloudJob.PROP_STATUS) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return JobResource.this.map.get("status");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == ICloudJob.PROP_APPLICATION) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return JobResource.this.map.get("application");
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == ICloudJob.PROP_OPERATION) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return JobResource.this.map.get("operation");
                    }

                    public void write(String value) {
                    }
                };
            }
            return null;
        }
    }
}

