/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java;

import oracle.eclipse.tools.cloud.java.ConflictResolver;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sapphire.modeling.Path;

public abstract class ResourceFacade {
    private final FolderFacade parent;
    private final String name;
    private String modified;

    protected ResourceFacade(FolderFacade parent, String name, String modified) {
        this.parent = parent;
        this.name = name;
        this.modified = modified;
    }

    protected final synchronized void update(String modified) {
        this.modified = modified;
    }

    public FolderFacade root() {
        return this.parent.root();
    }

    public final FolderFacade parent() {
        return this.parent;
    }

    public final boolean descendant(FolderFacade folder) {
        if (folder == null) {
            throw new IllegalArgumentException();
        }
        FolderFacade ancestor = this.parent();
        while (ancestor != null) {
            if (ancestor == folder) {
                return true;
            }
            ancestor = ancestor.parent();
        }
        return false;
    }

    public final String name() {
        return this.name;
    }

    public final Path path() {
        if (this.parent != null) {
            return this.parent.path().append(this.name);
        }
        return new Path(this.name);
    }

    public final synchronized String modified() {
        return this.modified;
    }

    public final ResourceFacade rename(String newName) {
        return this.rename(newName, null);
    }

    public final ResourceFacade rename(String newName, ConflictResolver conflictResolver) {
        if (newName == null) {
            throw new IllegalArgumentException();
        }
        if (conflictResolver == null) {
            conflictResolver = new ConflictResolver();
        }
        FolderFacade parent = this.parent();
        parent.members().fetch();
        ResourceFacade existing = parent.member(newName);
        if (existing != null) {
            ConflictResolver.Resolution resolution = conflictResolver.resolve(parent.path().append(newName));
            if (resolution == ConflictResolver.Resolution.SKIP || resolution == ConflictResolver.Resolution.ABORT) {
                return null;
            }
            if (resolution == ConflictResolver.Resolution.OVERWRITE) {
                existing.delete();
            } else {
                throw new IllegalStateException();
            }
        }
        this.renameResource(newName);
        parent.members().fetch();
        return parent.member(newName);
    }

    protected abstract void renameResource(String var1);

    public final ResourceFacade copy(FolderFacade destination, IProgressMonitor monitor) {
        return this.copy(destination, null, monitor);
    }

    public final ResourceFacade copy(FolderFacade destination, ConflictResolver conflictResolver, IProgressMonitor monitor) {
        return this.copy(destination, null, conflictResolver, monitor);
    }

    public abstract ResourceFacade copy(FolderFacade var1, String var2, ConflictResolver var3, IProgressMonitor var4);

    public abstract void delete();

    public void dispose() {
    }
}

