/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.LocalFile;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import org.eclipse.sapphire.util.ListFactory;

public final class LocalFolder
extends FolderFacade {
    private final File base;

    public LocalFolder(LocalFolder parent, File base) {
        super(parent, base.getName(), null);
        this.base = base;
    }

    public File base() {
        return this.base;
    }

    @Override
    protected Members createMembers() {
        return new Members(this);
    }

    @Override
    protected void createFolder(String name) {
        new File(this.base, name).mkdir();
    }

    @Override
    protected void createFile(String name) {
        try {
            new File(this.base, name).createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected final void renameResource(String newName) {
        this.base.renameTo(new File(this.base.getParentFile(), newName));
    }

    @Override
    public void delete() {
        for (ResourceFacade member : (List)this.members().content()) {
            member.delete();
        }
        this.base.delete();
        this.parent().members().fetch();
    }

    private static final class Members
    extends FolderFacade.Members {
        private Map<String, ResourceFacade> cache;

        public Members(LocalFolder folder) {
            super(folder, null);
        }

        @Override
        protected List<ResourceFacade> read() throws Exception {
            LocalFolder folder = (LocalFolder)this.folder();
            ListFactory membersListFactory = ListFactory.start();
            HashMap<String, ResourceFacade> newCache = new HashMap<String, ResourceFacade>();
            File[] fileArray = folder.base().listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                String name = child.getName();
                ResourceFacade resource = null;
                if (this.cache != null) {
                    resource = this.cache.get(name);
                }
                if (child.isDirectory()) {
                    if (!(resource instanceof LocalFolder)) {
                        resource = new LocalFolder(folder, child);
                    }
                } else if (!(resource instanceof LocalFile)) {
                    resource = new LocalFile(folder, child);
                }
                membersListFactory.add((Object)resource);
                newCache.put(name, resource);
                ++n2;
            }
            this.flush(newCache);
            return membersListFactory.result();
        }

        private void flush(Map<String, ResourceFacade> newCache) {
            if (this.cache != null) {
                for (Map.Entry<String, ResourceFacade> entry : this.cache.entrySet()) {
                    String name = entry.getKey();
                    ResourceFacade resource = entry.getValue();
                    if (resource == newCache.get(name)) continue;
                    resource.dispose();
                }
            }
            this.cache = newCache;
        }
    }
}

