/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.eclipse.tools.cloud.java.FileFacade;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.JavaServiceFile;
import oracle.eclipse.tools.cloud.java.JavaServiceFolder;
import oracle.eclipse.tools.cloud.java.LocalFolder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class LocalFile
extends FileFacade {
    private final File base;

    public LocalFile(LocalFolder parent, File base) {
        super(parent, base.getName(), null, null, base.length());
        this.base = base;
    }

    public File base() {
        return this.base;
    }

    @Override
    public InputStream content() {
        try {
            return new FileInputStream(this.base);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(InputStream content) {
        try {
            FileOutputStream out = new FileOutputStream(this.base);
            try {
                IOUtils.copy((InputStream)content, (OutputStream)out);
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void copyFile(FolderFacade destination, String name) {
        if (destination instanceof LocalFolder) {
            try {
                FileUtils.copyFile((File)this.base, (File)new File(((LocalFolder)destination).base(), name));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (destination instanceof JavaServiceFolder) {
            JavaServiceFolder targetFolder = (JavaServiceFolder)destination;
            JavaServiceFile targetFile = (JavaServiceFile)targetFolder.file(name, true);
            if (targetFile == null) {
                throw new RuntimeException("Error copy file " + name);
            }
            targetFile.write(this.base);
        } else {
            super.copyFile(destination, name);
        }
    }

    @Override
    protected final void renameResource(String newName) {
        this.base.renameTo(new File(this.base.getParentFile(), newName));
    }

    @Override
    public void delete() {
        this.base.delete();
        this.parent().members().fetch();
    }
}

